package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class CapabilitiesBuilder extends CapabilitiesFluentImpl<CapabilitiesBuilder> implements VisitableBuilder<Capabilities,CapabilitiesBuilder>{

    CapabilitiesFluent<?> fluent;
    Boolean validationEnabled;

    public CapabilitiesBuilder(){
            this(true);
    }
    public CapabilitiesBuilder(Boolean validationEnabled){
            this(new Capabilities(), validationEnabled);
    }
    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent){
            this(fluent, true);
    }
    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Capabilities(), validationEnabled);
    }
    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Capabilities instance){
            this(fluent, instance, true);
    }
    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Capabilities instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAdd(instance.getAdd()); 
            fluent.withDrop(instance.getDrop()); 
            this.validationEnabled = validationEnabled; 
    }
    public CapabilitiesBuilder(Capabilities instance){
            this(instance,true);
    }
    public CapabilitiesBuilder(Capabilities instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAdd(instance.getAdd()); 
            this.withDrop(instance.getDrop()); 
            this.validationEnabled = validationEnabled; 
    }

    public Capabilities build(){
            Capabilities buildable = new Capabilities(fluent.getAdd(),fluent.getDrop());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CapabilitiesBuilder that = (CapabilitiesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
