package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Long;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class TagReferenceFluentImpl<A extends TagReferenceFluent<A>> extends BaseFluent<A> implements TagReferenceFluent<A>{

    private Map<String,String> annotations = new LinkedHashMap<String,String>();
    private VisitableBuilder<? extends ObjectReference,?> from;
    private Long generation;
    private VisitableBuilder<? extends TagImportPolicy,?> importPolicy;
    private String name;
    private Boolean reference;

    public TagReferenceFluentImpl(){
    }
    public TagReferenceFluentImpl(TagReference instance){
            this.withAnnotations(instance.getAnnotations()); 
            this.withFrom(instance.getFrom()); 
            this.withGeneration(instance.getGeneration()); 
            this.withImportPolicy(instance.getImportPolicy()); 
            this.withName(instance.getName()); 
            this.withReference(instance.getReference()); 
    }

    public A addToAnnotations(String key,String value){
            if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map){
            if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key){
            if(key != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.annotations.remove(key);}} return (A)this;
    }

    public Map<String,String> getAnnotations(){
            return this.annotations;
    }

    public A withAnnotations(Map<String,String> annotations){
            this.annotations.clear();
            if (annotations != null) {this.annotations.putAll(annotations);} return (A) this;
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public TagReferenceFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public TagReferenceFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public TagReferenceFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public TagImportPolicy getImportPolicy(){
            return this.importPolicy!=null?this.importPolicy.build():null;
    }

    public A withImportPolicy(TagImportPolicy importPolicy){
            if (importPolicy!=null){ this.importPolicy= new TagImportPolicyBuilder(importPolicy); _visitables.add(this.importPolicy);} return (A) this;
    }

    public TagReferenceFluent.ImportPolicyNested<A> withNewImportPolicy(){
            return new ImportPolicyNestedImpl();
    }

    public TagReferenceFluent.ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item){
            return new ImportPolicyNestedImpl(item);
    }

    public TagReferenceFluent.ImportPolicyNested<A> editImportPolicy(){
            return withNewImportPolicyLike(getImportPolicy());
    }

    public A withNewImportPolicy(Boolean insecure,Boolean scheduled){
            return (A)withImportPolicy(new TagImportPolicy(insecure, scheduled));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean isReference(){
            return this.reference;
    }

    public A withReference(Boolean reference){
            this.reference=reference; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TagReferenceFluentImpl that = (TagReferenceFluentImpl) o;
            if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (importPolicy != null ? !importPolicy.equals(that.importPolicy) :that.importPolicy != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (reference != null ? !reference.equals(that.reference) :that.reference != null) return false;
            return true;
    }


    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<TagReferenceFluent.FromNested<N>> implements TagReferenceFluent.FromNested<N>,Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
    
    public N endFrom(){
            return and();
    }
    public N and(){
            return (N) TagReferenceFluentImpl.this.withFrom(builder.build());
    }

}
    public class ImportPolicyNestedImpl<N> extends TagImportPolicyFluentImpl<TagReferenceFluent.ImportPolicyNested<N>> implements TagReferenceFluent.ImportPolicyNested<N>,Nested<N>{

            private final TagImportPolicyBuilder builder;
    
            ImportPolicyNestedImpl(TagImportPolicy item){
                    this.builder = new TagImportPolicyBuilder(this, item);
            }
            ImportPolicyNestedImpl(){
                    this.builder = new TagImportPolicyBuilder(this);
            }
    
    public N endImportPolicy(){
            return and();
    }
    public N and(){
            return (N) TagReferenceFluentImpl.this.withImportPolicy(builder.build());
    }

}


}
