package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SourceRevisionFluent<A extends SourceRevisionFluent<A>> extends Fluent<A>{


    public GitSourceRevision getGit();
    public A withGit(GitSourceRevision git);
    public SourceRevisionFluent.GitNested<A> withNewGit();
    public SourceRevisionFluent.GitNested<A> withNewGitLike(GitSourceRevision item);
    public SourceRevisionFluent.GitNested<A> editGit();
    public String getType();
    public A withType(String type);

    public interface GitNested<N> extends Nested<N>,GitSourceRevisionFluent<SourceRevisionFluent.GitNested<N>>{

        
    public N and();    public N endGit();
}


}
