package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;

public interface RouteSpecFluent<A extends RouteSpecFluent<A>> extends Fluent<A>{


    public A addToAlternateBackends(RouteTargetReference... items);
    public A removeFromAlternateBackends(RouteTargetReference... items);
    public List<RouteTargetReference> getAlternateBackends();
    public A withAlternateBackends(List<RouteTargetReference> alternateBackends);
    public A withAlternateBackends(RouteTargetReference... alternateBackends);
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackend();
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item);
    public A addNewAlternateBackend(String kind,String name,Integer weight);
    public String getHost();
    public A withHost(String host);
    public String getPath();
    public A withPath(String path);
    public RoutePort getPort();
    public A withPort(RoutePort port);
    public RouteSpecFluent.PortNested<A> withNewPort();
    public RouteSpecFluent.PortNested<A> withNewPortLike(RoutePort item);
    public RouteSpecFluent.PortNested<A> editPort();
    public TLSConfig getTls();
    public A withTls(TLSConfig tls);
    public RouteSpecFluent.TlsNested<A> withNewTls();
    public RouteSpecFluent.TlsNested<A> withNewTlsLike(TLSConfig item);
    public RouteSpecFluent.TlsNested<A> editTls();
    public RouteTargetReference getTo();
    public A withTo(RouteTargetReference to);
    public RouteSpecFluent.ToNested<A> withNewTo();
    public RouteSpecFluent.ToNested<A> withNewToLike(RouteTargetReference item);
    public RouteSpecFluent.ToNested<A> editTo();
    public A withNewTo(String kind,String name,Integer weight);

    public interface AlternateBackendsNested<N> extends Nested<N>,RouteTargetReferenceFluent<RouteSpecFluent.AlternateBackendsNested<N>>{

        
    public N endAlternateBackend();    public N and();
}
    public interface PortNested<N> extends Nested<N>,RoutePortFluent<RouteSpecFluent.PortNested<N>>{

        
    public N endPort();    public N and();
}
    public interface TlsNested<N> extends Nested<N>,TLSConfigFluent<RouteSpecFluent.TlsNested<N>>{

        
    public N endTls();    public N and();
}
    public interface ToNested<N> extends Nested<N>,RouteTargetReferenceFluent<RouteSpecFluent.ToNested<N>>{

        
    public N and();    public N endTo();
}


}
