package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class PolicyRuleBuilder extends PolicyRuleFluentImpl<PolicyRuleBuilder> implements VisitableBuilder<PolicyRule,PolicyRuleBuilder>{

    PolicyRuleFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyRuleBuilder(){
            this(true);
    }
    public PolicyRuleBuilder(Boolean validationEnabled){
            this(new PolicyRule(), validationEnabled);
    }
    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyRule(), validationEnabled);
    }
    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent,PolicyRule instance){
            this(fluent, instance, true);
    }
    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent,PolicyRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiGroups(instance.getApiGroups()); 
            fluent.withAttributeRestrictions(instance.getAttributeRestrictions()); 
            fluent.withNonResourceURLs(instance.getNonResourceURLs()); 
            fluent.withResourceNames(instance.getResourceNames()); 
            fluent.withResources(instance.getResources()); 
            fluent.withVerbs(instance.getVerbs()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicyRuleBuilder(PolicyRule instance){
            this(instance,true);
    }
    public PolicyRuleBuilder(PolicyRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiGroups(instance.getApiGroups()); 
            this.withAttributeRestrictions(instance.getAttributeRestrictions()); 
            this.withNonResourceURLs(instance.getNonResourceURLs()); 
            this.withResourceNames(instance.getResourceNames()); 
            this.withResources(instance.getResources()); 
            this.withVerbs(instance.getVerbs()); 
            this.validationEnabled = validationEnabled; 
    }

    public PolicyRule build(){
            PolicyRule buildable = new PolicyRule(fluent.getApiGroups(),fluent.getAttributeRestrictions(),fluent.getNonResourceURLs(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyRuleBuilder that = (PolicyRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
