package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ImageStreamStatusFluent<A extends ImageStreamStatusFluent<A>> extends Fluent<A>{


    public String getDockerImageRepository();
    public A withDockerImageRepository(String dockerImageRepository);
    public A addToTags(NamedTagEventList... items);
    public A removeFromTags(NamedTagEventList... items);
    public List<NamedTagEventList> getTags();
    public A withTags(List<NamedTagEventList> tags);
    public A withTags(NamedTagEventList... tags);
    public ImageStreamStatusFluent.TagsNested<A> addNewTag();
    public ImageStreamStatusFluent.TagsNested<A> addNewTagLike(NamedTagEventList item);

    public interface TagsNested<N> extends Nested<N>,NamedTagEventListFluent<ImageStreamStatusFluent.TagsNested<N>>{

        
    public N endTag();    public N and();
}


}
