package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class ImageChangeCauseFluentImpl<A extends ImageChangeCauseFluent<A>> extends BaseFluent<A> implements ImageChangeCauseFluent<A>{

    private VisitableBuilder<? extends ObjectReference,?> fromRef;
    private String imageID;

    public ImageChangeCauseFluentImpl(){
    }
    public ImageChangeCauseFluentImpl(ImageChangeCause instance){
            this.withFromRef(instance.getFromRef()); 
            this.withImageID(instance.getImageID()); 
    }

    public ObjectReference getFromRef(){
            return this.fromRef!=null?this.fromRef.build():null;
    }

    public A withFromRef(ObjectReference fromRef){
            if (fromRef!=null){ this.fromRef= new ObjectReferenceBuilder(fromRef); _visitables.add(this.fromRef);} return (A) this;
    }

    public ImageChangeCauseFluent.FromRefNested<A> withNewFromRef(){
            return new FromRefNestedImpl();
    }

    public ImageChangeCauseFluent.FromRefNested<A> withNewFromRefLike(ObjectReference item){
            return new FromRefNestedImpl(item);
    }

    public ImageChangeCauseFluent.FromRefNested<A> editFromRef(){
            return withNewFromRefLike(getFromRef());
    }

    public String getImageID(){
            return this.imageID;
    }

    public A withImageID(String imageID){
            this.imageID=imageID; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageChangeCauseFluentImpl that = (ImageChangeCauseFluentImpl) o;
            if (fromRef != null ? !fromRef.equals(that.fromRef) :that.fromRef != null) return false;
            if (imageID != null ? !imageID.equals(that.imageID) :that.imageID != null) return false;
            return true;
    }


    public class FromRefNestedImpl<N> extends ObjectReferenceFluentImpl<ImageChangeCauseFluent.FromRefNested<N>> implements ImageChangeCauseFluent.FromRefNested<N>,Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromRefNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
            FromRefNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
    
    public N and(){
            return (N) ImageChangeCauseFluentImpl.this.withFromRef(builder.build());
    }
    public N endFromRef(){
            return and();
    }

}


}
