package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class ClusterRoleBuilder extends ClusterRoleFluentImpl<ClusterRoleBuilder> implements VisitableBuilder<ClusterRole,ClusterRoleBuilder>{

    ClusterRoleFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterRoleBuilder(){
            this(true);
    }
    public ClusterRoleBuilder(Boolean validationEnabled){
            this(new ClusterRole(), validationEnabled);
    }
    public ClusterRoleBuilder(ClusterRoleFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterRole(), validationEnabled);
    }
    public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,ClusterRole instance){
            this(fluent, instance, true);
    }
    public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,ClusterRole instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRules(instance.getRules()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterRoleBuilder(ClusterRole instance){
            this(instance,true);
    }
    public ClusterRoleBuilder(ClusterRole instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRules(instance.getRules()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterRole build(){
            ClusterRole buildable = new ClusterRole(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRules());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterRoleBuilder that = (ClusterRoleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
