package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class PetSetSpecBuilder extends PetSetSpecFluentImpl<PetSetSpecBuilder> implements VisitableBuilder<PetSetSpec,PetSetSpecBuilder>{

    PetSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetSpecBuilder(){
            this(true);
    }
    public PetSetSpecBuilder(Boolean validationEnabled){
            this(new PetSetSpec(), validationEnabled);
    }
    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PetSetSpec(), validationEnabled);
    }
    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent,PetSetSpec instance){
            this(fluent, instance, true);
    }
    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent,PetSetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withServiceName(instance.getServiceName()); 
            fluent.withTemplate(instance.getTemplate()); 
            fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
            this.validationEnabled = validationEnabled; 
    }
    public PetSetSpecBuilder(PetSetSpec instance){
            this(instance,true);
    }
    public PetSetSpecBuilder(PetSetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas()); 
            this.withSelector(instance.getSelector()); 
            this.withServiceName(instance.getServiceName()); 
            this.withTemplate(instance.getTemplate()); 
            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
            this.validationEnabled = validationEnabled; 
    }

    public PetSetSpec build(){
            PetSetSpec buildable = new PetSetSpec(fluent.getReplicas(),fluent.getSelector(),fluent.getServiceName(),fluent.getTemplate(),fluent.getVolumeClaimTemplates());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetSpecBuilder that = (PetSetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
