package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Boolean;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PreferencesFluent<A extends PreferencesFluent<A>> extends Fluent<A>{


    public Boolean isColors();
    public A withColors(Boolean colors);
    public A addToExtensions(NamedExtension... items);
    public A removeFromExtensions(NamedExtension... items);
    public List<NamedExtension> getExtensions();
    public A withExtensions(List<NamedExtension> extensions);
    public A withExtensions(NamedExtension... extensions);
    public PreferencesFluent.ExtensionsNested<A> addNewExtension();
    public PreferencesFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);

    public interface ExtensionsNested<N> extends Nested<N>,NamedExtensionFluent<PreferencesFluent.ExtensionsNested<N>>{

        
    public N and();    public N endExtension();
}


}
