package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.validation.Valid;
import java.lang.Boolean;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface FlexVolumeSourceFluent<A extends FlexVolumeSourceFluent<A>> extends Fluent<A>{


    public String getDriver();
    public A withDriver(String driver);
    public String getFsType();
    public A withFsType(String fsType);
    public A addToOptions(String key,String value);
    public A addToOptions(Map<String,String> map);
    public A removeFromOptions(String key);
    public A removeFromOptions(Map<String,String> map);
    public Map<String,String> getOptions();
    public A withOptions(Map<String,String> options);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public LocalObjectReference getSecretRef();
    public A withSecretRef(LocalObjectReference secretRef);
    public FlexVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
    public FlexVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item);
    public FlexVolumeSourceFluent.SecretRefNested<A> editSecretRef();
    public A withNewSecretRef(String name);

    public interface SecretRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<FlexVolumeSourceFluent.SecretRefNested<N>>{

        
    public N endSecretRef();    public N and();
}


}
