package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class EndpointAddressBuilder extends EndpointAddressFluentImpl<EndpointAddressBuilder> implements VisitableBuilder<EndpointAddress,EndpointAddressBuilder>{

    EndpointAddressFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointAddressBuilder(){
            this(true);
    }
    public EndpointAddressBuilder(Boolean validationEnabled){
            this(new EndpointAddress(), validationEnabled);
    }
    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent){
            this(fluent, true);
    }
    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EndpointAddress(), validationEnabled);
    }
    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent,EndpointAddress instance){
            this(fluent, instance, true);
    }
    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent,EndpointAddress instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHostname(instance.getHostname()); 
            fluent.withIp(instance.getIp()); 
            fluent.withTargetRef(instance.getTargetRef()); 
            this.validationEnabled = validationEnabled; 
    }
    public EndpointAddressBuilder(EndpointAddress instance){
            this(instance,true);
    }
    public EndpointAddressBuilder(EndpointAddress instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHostname(instance.getHostname()); 
            this.withIp(instance.getIp()); 
            this.withTargetRef(instance.getTargetRef()); 
            this.validationEnabled = validationEnabled; 
    }

    public EndpointAddress build(){
            EndpointAddress buildable = new EndpointAddress(fluent.getHostname(),fluent.getIp(),fluent.getTargetRef());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointAddressBuilder that = (EndpointAddressBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
