package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DownwardAPIVolumeSourceFluentImpl<A extends DownwardAPIVolumeSourceFluent<A>> extends BaseFluent<A> implements DownwardAPIVolumeSourceFluent<A>{

    private List<VisitableBuilder<? extends DownwardAPIVolumeFile,?>> items =  new ArrayList<VisitableBuilder<? extends DownwardAPIVolumeFile,?>>();

    public DownwardAPIVolumeSourceFluentImpl(){
    }
    public DownwardAPIVolumeSourceFluentImpl(DownwardAPIVolumeSource instance){
            this.withItems(instance.getItems()); 
    }

    public A addToItems(DownwardAPIVolumeFile... items){
            for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(DownwardAPIVolumeFile... items){
            for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<DownwardAPIVolumeFile> getItems(){
            return build(items);
    }

    public A withItems(List<DownwardAPIVolumeFile> items){
            this.items.clear();
            if (items != null) {for (DownwardAPIVolumeFile item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(DownwardAPIVolumeFile... items){
            this.items.clear(); if (items != null) {for (DownwardAPIVolumeFile item :items){ this.addToItems(item);}} return (A) this;
    }

    public DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(DownwardAPIVolumeFile item){
            return new ItemsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DownwardAPIVolumeSourceFluentImpl that = (DownwardAPIVolumeSourceFluentImpl) o;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends DownwardAPIVolumeFileFluentImpl<DownwardAPIVolumeSourceFluent.ItemsNested<N>> implements DownwardAPIVolumeSourceFluent.ItemsNested<N>,Nested<N>{

            private final DownwardAPIVolumeFileBuilder builder;
    
            ItemsNestedImpl(DownwardAPIVolumeFile item){
                    this.builder = new DownwardAPIVolumeFileBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.builder = new DownwardAPIVolumeFileBuilder(this);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) DownwardAPIVolumeSourceFluentImpl.this.addToItems(builder.build());
    }

}


}
