package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ClusterFluent<A extends ClusterFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getCertificateAuthority();
    public A withCertificateAuthority(String certificateAuthority);
    public String getCertificateAuthorityData();
    public A withCertificateAuthorityData(String certificateAuthorityData);
    public A addToExtensions(NamedExtension... items);
    public A removeFromExtensions(NamedExtension... items);
    public List<NamedExtension> getExtensions();
    public A withExtensions(List<NamedExtension> extensions);
    public A withExtensions(NamedExtension... extensions);
    public ClusterFluent.ExtensionsNested<A> addNewExtension();
    public ClusterFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
    public Boolean isInsecureSkipTlsVerify();
    public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify);
    public String getServer();
    public A withServer(String server);

    public interface ExtensionsNested<N> extends Nested<N>,NamedExtensionFluent<ClusterFluent.ExtensionsNested<N>>{

        
    public N and();    public N endExtension();
}


}
