package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface CephFSVolumeSourceFluent<A extends CephFSVolumeSourceFluent<A>> extends Fluent<A>{


    public A addToMonitors(String... items);
    public A removeFromMonitors(String... items);
    public List<String> getMonitors();
    public A withMonitors(List<String> monitors);
    public A withMonitors(String... monitors);
    public String getPath();
    public A withPath(String path);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public String getSecretFile();
    public A withSecretFile(String secretFile);
    public LocalObjectReference getSecretRef();
    public A withSecretRef(LocalObjectReference secretRef);
    public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
    public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item);
    public CephFSVolumeSourceFluent.SecretRefNested<A> editSecretRef();
    public A withNewSecretRef(String name);
    public String getUser();
    public A withUser(String user);

    public interface SecretRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<CephFSVolumeSourceFluent.SecretRefNested<N>>{

        
    public N endSecretRef();    public N and();
}


}
