package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.String;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class RouteSpecFluentImpl<A extends RouteSpecFluent<A>> extends BaseFluent<A> implements RouteSpecFluent<A>{

    private List<VisitableBuilder<? extends RouteTargetReference,?>> alternateBackends =  new ArrayList<VisitableBuilder<? extends RouteTargetReference,?>>();
    private String host;
    private String path;
    private VisitableBuilder<? extends RoutePort,?> port;
    private VisitableBuilder<? extends TLSConfig,?> tls;
    private VisitableBuilder<? extends RouteTargetReference,?> to;

    public RouteSpecFluentImpl(){
    }
    public RouteSpecFluentImpl(RouteSpec instance){
            this.withAlternateBackends(instance.getAlternateBackends()); 
            this.withHost(instance.getHost()); 
            this.withPath(instance.getPath()); 
            this.withPort(instance.getPort()); 
            this.withTls(instance.getTls()); 
            this.withTo(instance.getTo()); 
    }

    public A addToAlternateBackends(RouteTargetReference... items){
            for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.add(builder);this.alternateBackends.add(builder);} return (A)this;
    }

    public A removeFromAlternateBackends(RouteTargetReference... items){
            for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.remove(builder);this.alternateBackends.remove(builder);} return (A)this;
    }

    public List<RouteTargetReference> getAlternateBackends(){
            return build(alternateBackends);
    }

    public A withAlternateBackends(List<RouteTargetReference> alternateBackends){
            this.alternateBackends.clear();
            if (alternateBackends != null) {for (RouteTargetReference item : alternateBackends){this.addToAlternateBackends(item);}} return (A) this;
    }

    public A withAlternateBackends(RouteTargetReference... alternateBackends){
            this.alternateBackends.clear(); if (alternateBackends != null) {for (RouteTargetReference item :alternateBackends){ this.addToAlternateBackends(item);}} return (A) this;
    }

    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackend(){
            return new AlternateBackendsNestedImpl();
    }

    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item){
            return new AlternateBackendsNestedImpl(item);
    }

    public A addNewAlternateBackend(String kind,String name,Integer weight){
            return (A)addToAlternateBackends(new RouteTargetReference(kind, name, weight));
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public RoutePort getPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(RoutePort port){
            if (port!=null){ this.port= new RoutePortBuilder(port); _visitables.add(this.port);} return (A) this;
    }

    public RouteSpecFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public RouteSpecFluent.PortNested<A> withNewPortLike(RoutePort item){
            return new PortNestedImpl(item);
    }

    public RouteSpecFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public TLSConfig getTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public A withTls(TLSConfig tls){
            if (tls!=null){ this.tls= new TLSConfigBuilder(tls); _visitables.add(this.tls);} return (A) this;
    }

    public RouteSpecFluent.TlsNested<A> withNewTls(){
            return new TlsNestedImpl();
    }

    public RouteSpecFluent.TlsNested<A> withNewTlsLike(TLSConfig item){
            return new TlsNestedImpl(item);
    }

    public RouteSpecFluent.TlsNested<A> editTls(){
            return withNewTlsLike(getTls());
    }

    public RouteTargetReference getTo(){
            return this.to!=null?this.to.build():null;
    }

    public A withTo(RouteTargetReference to){
            if (to!=null){ this.to= new RouteTargetReferenceBuilder(to); _visitables.add(this.to);} return (A) this;
    }

    public RouteSpecFluent.ToNested<A> withNewTo(){
            return new ToNestedImpl();
    }

    public RouteSpecFluent.ToNested<A> withNewToLike(RouteTargetReference item){
            return new ToNestedImpl(item);
    }

    public RouteSpecFluent.ToNested<A> editTo(){
            return withNewToLike(getTo());
    }

    public A withNewTo(String kind,String name,Integer weight){
            return (A)withTo(new RouteTargetReference(kind, name, weight));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteSpecFluentImpl that = (RouteSpecFluentImpl) o;
            if (alternateBackends != null ? !alternateBackends.equals(that.alternateBackends) :that.alternateBackends != null) return false;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            if (to != null ? !to.equals(that.to) :that.to != null) return false;
            return true;
    }


    public class AlternateBackendsNestedImpl<N> extends RouteTargetReferenceFluentImpl<RouteSpecFluent.AlternateBackendsNested<N>> implements RouteSpecFluent.AlternateBackendsNested<N>,Nested<N>{

            private final RouteTargetReferenceBuilder builder;
    
            AlternateBackendsNestedImpl(){
                    this.builder = new RouteTargetReferenceBuilder(this);
            }
            AlternateBackendsNestedImpl(RouteTargetReference item){
                    this.builder = new RouteTargetReferenceBuilder(this, item);
            }
    
    public N endAlternateBackend(){
            return and();
    }
    public N and(){
            return (N) RouteSpecFluentImpl.this.addToAlternateBackends(builder.build());
    }

}
    public class PortNestedImpl<N> extends RoutePortFluentImpl<RouteSpecFluent.PortNested<N>> implements RouteSpecFluent.PortNested<N>,Nested<N>{

            private final RoutePortBuilder builder;
    
            PortNestedImpl(){
                    this.builder = new RoutePortBuilder(this);
            }
            PortNestedImpl(RoutePort item){
                    this.builder = new RoutePortBuilder(this, item);
            }
    
    public N endPort(){
            return and();
    }
    public N and(){
            return (N) RouteSpecFluentImpl.this.withPort(builder.build());
    }

}
    public class TlsNestedImpl<N> extends TLSConfigFluentImpl<RouteSpecFluent.TlsNested<N>> implements RouteSpecFluent.TlsNested<N>,Nested<N>{

            private final TLSConfigBuilder builder;
    
            TlsNestedImpl(){
                    this.builder = new TLSConfigBuilder(this);
            }
            TlsNestedImpl(TLSConfig item){
                    this.builder = new TLSConfigBuilder(this, item);
            }
    
    public N endTls(){
            return and();
    }
    public N and(){
            return (N) RouteSpecFluentImpl.this.withTls(builder.build());
    }

}
    public class ToNestedImpl<N> extends RouteTargetReferenceFluentImpl<RouteSpecFluent.ToNested<N>> implements RouteSpecFluent.ToNested<N>,Nested<N>{

            private final RouteTargetReferenceBuilder builder;
    
            ToNestedImpl(){
                    this.builder = new RouteTargetReferenceBuilder(this);
            }
            ToNestedImpl(RouteTargetReference item){
                    this.builder = new RouteTargetReferenceBuilder(this, item);
            }
    
    public N and(){
            return (N) RouteSpecFluentImpl.this.withTo(builder.build());
    }
    public N endTo(){
            return and();
    }

}


}
