package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface OAuthAuthorizeTokenListFluent<A extends OAuthAuthorizeTokenListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(OAuthAuthorizeToken... items);
    public A removeFromItems(OAuthAuthorizeToken... items);
    public List<OAuthAuthorizeToken> getItems();
    public A withItems(List<OAuthAuthorizeToken> items);
    public A withItems(OAuthAuthorizeToken... items);
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> addNewItem();
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> addNewItemLike(OAuthAuthorizeToken item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public OAuthAuthorizeTokenListFluent.MetadataNested<A> withNewMetadata();
    public OAuthAuthorizeTokenListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public OAuthAuthorizeTokenListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<OAuthAuthorizeTokenListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
