package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ImageStreamSpecFluent<A extends ImageStreamSpecFluent<A>> extends Fluent<A>{


    public String getDockerImageRepository();
    public A withDockerImageRepository(String dockerImageRepository);
    public A addToTags(TagReference... items);
    public A removeFromTags(TagReference... items);
    public List<TagReference> getTags();
    public A withTags(List<TagReference> tags);
    public A withTags(TagReference... tags);
    public ImageStreamSpecFluent.TagsNested<A> addNewTag();
    public ImageStreamSpecFluent.TagsNested<A> addNewTagLike(TagReference item);

    public interface TagsNested<N> extends Nested<N>,TagReferenceFluent<ImageStreamSpecFluent.TagsNested<N>>{

        
    public N endTag();    public N and();
}


}
