package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ImageStreamFluent<A extends ImageStreamFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ImageStreamFluent.MetadataNested<A> withNewMetadata();
    public ImageStreamFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageStreamFluent.MetadataNested<A> editMetadata();
    public ImageStreamSpec getSpec();
    public A withSpec(ImageStreamSpec spec);
    public ImageStreamFluent.SpecNested<A> withNewSpec();
    public ImageStreamFluent.SpecNested<A> withNewSpecLike(ImageStreamSpec item);
    public ImageStreamFluent.SpecNested<A> editSpec();
    public ImageStreamStatus getStatus();
    public A withStatus(ImageStreamStatus status);
    public ImageStreamFluent.StatusNested<A> withNewStatus();
    public ImageStreamFluent.StatusNested<A> withNewStatusLike(ImageStreamStatus item);
    public ImageStreamFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ImageStreamFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ImageStreamSpecFluent<ImageStreamFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,ImageStreamStatusFluent<ImageStreamFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
