package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class GenericWebHookCauseBuilder extends GenericWebHookCauseFluentImpl<GenericWebHookCauseBuilder> implements VisitableBuilder<GenericWebHookCause,GenericWebHookCauseBuilder>{

    GenericWebHookCauseFluent<?> fluent;
    Boolean validationEnabled;

    public GenericWebHookCauseBuilder(){
            this(true);
    }
    public GenericWebHookCauseBuilder(Boolean validationEnabled){
            this(new GenericWebHookCause(), validationEnabled);
    }
    public GenericWebHookCauseBuilder(GenericWebHookCauseFluent<?> fluent){
            this(fluent, true);
    }
    public GenericWebHookCauseBuilder(GenericWebHookCauseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GenericWebHookCause(), validationEnabled);
    }
    public GenericWebHookCauseBuilder(GenericWebHookCauseFluent<?> fluent,GenericWebHookCause instance){
            this(fluent, instance, true);
    }
    public GenericWebHookCauseBuilder(GenericWebHookCauseFluent<?> fluent,GenericWebHookCause instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRevision(instance.getRevision()); 
            fluent.withSecret(instance.getSecret()); 
            this.validationEnabled = validationEnabled; 
    }
    public GenericWebHookCauseBuilder(GenericWebHookCause instance){
            this(instance,true);
    }
    public GenericWebHookCauseBuilder(GenericWebHookCause instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRevision(instance.getRevision()); 
            this.withSecret(instance.getSecret()); 
            this.validationEnabled = validationEnabled; 
    }

    public GenericWebHookCause build(){
            GenericWebHookCause buildable = new GenericWebHookCause(fluent.getRevision(),fluent.getSecret());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GenericWebHookCauseBuilder that = (GenericWebHookCauseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
