package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Long;
import javax.validation.constraints.NotNull;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface DockerImageFluent<A extends DockerImageFluent<A>> extends Fluent<A>{


    public String getArchitecture();
    public A withArchitecture(String architecture);
    public String getAuthor();
    public A withAuthor(String author);
    public String getComment();
    public A withComment(String comment);
    public DockerConfig getConfig();
    public A withConfig(DockerConfig config);
    public DockerImageFluent.ConfigNested<A> withNewConfig();
    public DockerImageFluent.ConfigNested<A> withNewConfigLike(DockerConfig item);
    public DockerImageFluent.ConfigNested<A> editConfig();
    public String getContainer();
    public A withContainer(String container);
    public DockerConfig getContainerConfig();
    public A withContainerConfig(DockerConfig containerConfig);
    public DockerImageFluent.ContainerConfigNested<A> withNewContainerConfig();
    public DockerImageFluent.ContainerConfigNested<A> withNewContainerConfigLike(DockerConfig item);
    public DockerImageFluent.ContainerConfigNested<A> editContainerConfig();
    public String getCreated();
    public A withCreated(String created);
    public String getDockerVersion();
    public A withDockerVersion(String dockerVersion);
    public String getId();
    public A withId(String id);
    public String getParent();
    public A withParent(String parent);
    public Long getSize();
    public A withSize(Long size);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);

    public interface ConfigNested<N> extends Nested<N>,DockerConfigFluent<DockerImageFluent.ConfigNested<N>>{

        
    public N endConfig();    public N and();
}
    public interface ContainerConfigNested<N> extends Nested<N>,DockerConfigFluent<DockerImageFluent.ContainerConfigNested<N>>{

        
    public N endContainerConfig();    public N and();
}


}
