package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeploymentCauseFluentImpl<A extends DeploymentCauseFluent<A>> extends BaseFluent<A> implements DeploymentCauseFluent<A>{

    private VisitableBuilder<? extends DeploymentCauseImageTrigger,?> imageTrigger;
    private String type;

    public DeploymentCauseFluentImpl(){
    }
    public DeploymentCauseFluentImpl(DeploymentCause instance){
            this.withImageTrigger(instance.getImageTrigger()); 
            this.withType(instance.getType()); 
    }

    public DeploymentCauseImageTrigger getImageTrigger(){
            return this.imageTrigger!=null?this.imageTrigger.build():null;
    }

    public A withImageTrigger(DeploymentCauseImageTrigger imageTrigger){
            if (imageTrigger!=null){ this.imageTrigger= new DeploymentCauseImageTriggerBuilder(imageTrigger); _visitables.add(this.imageTrigger);} return (A) this;
    }

    public DeploymentCauseFluent.ImageTriggerNested<A> withNewImageTrigger(){
            return new ImageTriggerNestedImpl();
    }

    public DeploymentCauseFluent.ImageTriggerNested<A> withNewImageTriggerLike(DeploymentCauseImageTrigger item){
            return new ImageTriggerNestedImpl(item);
    }

    public DeploymentCauseFluent.ImageTriggerNested<A> editImageTrigger(){
            return withNewImageTriggerLike(getImageTrigger());
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentCauseFluentImpl that = (DeploymentCauseFluentImpl) o;
            if (imageTrigger != null ? !imageTrigger.equals(that.imageTrigger) :that.imageTrigger != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class ImageTriggerNestedImpl<N> extends DeploymentCauseImageTriggerFluentImpl<DeploymentCauseFluent.ImageTriggerNested<N>> implements DeploymentCauseFluent.ImageTriggerNested<N>,Nested<N>{

            private final DeploymentCauseImageTriggerBuilder builder;
    
            ImageTriggerNestedImpl(){
                    this.builder = new DeploymentCauseImageTriggerBuilder(this);
            }
            ImageTriggerNestedImpl(DeploymentCauseImageTrigger item){
                    this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
            }
    
    public N endImageTrigger(){
            return and();
    }
    public N and(){
            return (N) DeploymentCauseFluentImpl.this.withImageTrigger(builder.build());
    }

}


}
