package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ClusterRoleBindingListFluent<A extends ClusterRoleBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ClusterRoleBinding... items);
    public A removeFromItems(ClusterRoleBinding... items);
    public List<ClusterRoleBinding> getItems();
    public A withItems(List<ClusterRoleBinding> items);
    public A withItems(ClusterRoleBinding... items);
    public ClusterRoleBindingListFluent.ItemsNested<A> addNewItem();
    public ClusterRoleBindingListFluent.ItemsNested<A> addNewItemLike(ClusterRoleBinding item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ClusterRoleBindingListFluent.MetadataNested<A> withNewMetadata();
    public ClusterRoleBindingListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ClusterRoleBindingListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ClusterRoleBindingFluent<ClusterRoleBindingListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ClusterRoleBindingListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
