package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Boolean;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface BuildStatusFluent<A extends BuildStatusFluent<A>> extends Fluent<A>{


    public Boolean isCancelled();
    public A withCancelled(Boolean cancelled);
    public String getCompletionTimestamp();
    public A withCompletionTimestamp(String completionTimestamp);
    public ObjectReference getConfig();
    public A withConfig(ObjectReference config);
    public BuildStatusFluent.ConfigNested<A> withNewConfig();
    public BuildStatusFluent.ConfigNested<A> withNewConfigLike(ObjectReference item);
    public BuildStatusFluent.ConfigNested<A> editConfig();
    public Long getDuration();
    public A withDuration(Long duration);
    public String getMessage();
    public A withMessage(String message);
    public String getOutputDockerImageReference();
    public A withOutputDockerImageReference(String outputDockerImageReference);
    public String getPhase();
    public A withPhase(String phase);
    public String getReason();
    public A withReason(String reason);
    public String getStartTimestamp();
    public A withStartTimestamp(String startTimestamp);

    public interface ConfigNested<N> extends Nested<N>,ObjectReferenceFluent<BuildStatusFluent.ConfigNested<N>>{

        
    public N endConfig();    public N and();
}


}
