package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;

public class BuildPostCommitSpecFluentImpl<A extends BuildPostCommitSpecFluent<A>> extends BaseFluent<A> implements BuildPostCommitSpecFluent<A>{

    private List<String> args = new ArrayList<String>();
    private List<String> command = new ArrayList<String>();
    private String script;

    public BuildPostCommitSpecFluentImpl(){
    }
    public BuildPostCommitSpecFluentImpl(BuildPostCommitSpec instance){
            this.withArgs(instance.getArgs()); 
            this.withCommand(instance.getCommand()); 
            this.withScript(instance.getScript()); 
    }

    public A addToArgs(String... items){
            for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A removeFromArgs(String... items){
            for (String item : items) {this.args.remove(item);} return (A)this;
    }

    public List<String> getArgs(){
            return this.args;
    }

    public A withArgs(List<String> args){
            this.args.clear();
            if (args != null) {for (String item : args){this.addToArgs(item);}} return (A) this;
    }

    public A withArgs(String... args){
            this.args.clear(); if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
    }

    public A addToCommand(String... items){
            for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(String... items){
            for (String item : items) {this.command.remove(item);} return (A)this;
    }

    public List<String> getCommand(){
            return this.command;
    }

    public A withCommand(List<String> command){
            this.command.clear();
            if (command != null) {for (String item : command){this.addToCommand(item);}} return (A) this;
    }

    public A withCommand(String... command){
            this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public String getScript(){
            return this.script;
    }

    public A withScript(String script){
            this.script=script; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildPostCommitSpecFluentImpl that = (BuildPostCommitSpecFluentImpl) o;
            if (args != null ? !args.equals(that.args) :that.args != null) return false;
            if (command != null ? !command.equals(that.command) :that.command != null) return false;
            if (script != null ? !script.equals(that.script) :that.script != null) return false;
            return true;
    }




}
