package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface DeploymentListFluent<A extends DeploymentListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Deployment... items);
    public A removeFromItems(Deployment... items);
    public List<Deployment> getItems();
    public A withItems(List<Deployment> items);
    public A withItems(Deployment... items);
    public DeploymentListFluent.ItemsNested<A> addNewItem();
    public DeploymentListFluent.ItemsNested<A> addNewItemLike(Deployment item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public DeploymentListFluent.MetadataNested<A> withNewMetadata();
    public DeploymentListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public DeploymentListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,DeploymentFluent<DeploymentListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<DeploymentListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
