package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EndpointSubsetFluent<A extends EndpointSubsetFluent<A>> extends Fluent<A>{


    public A addToAddresses(EndpointAddress... items);
    public A removeFromAddresses(EndpointAddress... items);
    public List<EndpointAddress> getAddresses();
    public A withAddresses(List<EndpointAddress> addresses);
    public A withAddresses(EndpointAddress... addresses);
    public EndpointSubsetFluent.AddressesNested<A> addNewAddress();
    public EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(EndpointAddress item);
    public A addToNotReadyAddresses(EndpointAddress... items);
    public A removeFromNotReadyAddresses(EndpointAddress... items);
    public List<EndpointAddress> getNotReadyAddresses();
    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses);
    public A withNotReadyAddresses(EndpointAddress... notReadyAddresses);
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress();
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item);
    public A addToPorts(EndpointPort... items);
    public A removeFromPorts(EndpointPort... items);
    public List<EndpointPort> getPorts();
    public A withPorts(List<EndpointPort> ports);
    public A withPorts(EndpointPort... ports);
    public EndpointSubsetFluent.PortsNested<A> addNewPort();
    public EndpointSubsetFluent.PortsNested<A> addNewPortLike(EndpointPort item);
    public A addNewPort(String name,Integer port,String protocol);

    public interface AddressesNested<N> extends Nested<N>,EndpointAddressFluent<EndpointSubsetFluent.AddressesNested<N>>{

        
    public N endAddress();    public N and();
}
    public interface NotReadyAddressesNested<N> extends Nested<N>,EndpointAddressFluent<EndpointSubsetFluent.NotReadyAddressesNested<N>>{

        
    public N endNotReadyAddress();    public N and();
}
    public interface PortsNested<N> extends Nested<N>,EndpointPortFluent<EndpointSubsetFluent.PortsNested<N>>{

        
    public N endPort();    public N and();
}


}
