package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.kubernetes.api.model.extensions.PetSet;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Identity;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobBuilder;
import io.fabric8.openshift.api.model.ProjectFluentImpl;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.RouteFluentImpl;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentImpl;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluentImpl;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.TemplateFluentImpl;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.PolicyBindingFluentImpl;
import io.fabric8.openshift.api.model.PolicyBindingBuilder;
import io.fabric8.openshift.api.model.ClusterRoleFluentImpl;
import io.fabric8.openshift.api.model.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluentImpl;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluentImpl;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.ImageFluentImpl;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.openshift.api.model.RoleFluentImpl;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.openshift.api.model.UserFluentImpl;
import io.fabric8.openshift.api.model.UserBuilder;
import io.fabric8.openshift.api.model.BuildFluentImpl;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;
import io.fabric8.openshift.api.model.GroupFluentImpl;
import io.fabric8.openshift.api.model.GroupBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSetFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.PetSetBuilder;
import io.fabric8.openshift.api.model.PolicyFluentImpl;
import io.fabric8.openshift.api.model.PolicyBuilder;
import io.fabric8.openshift.api.model.ImageSignatureFluentImpl;
import io.fabric8.openshift.api.model.ImageSignatureBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluentImpl;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBindingBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluentImpl;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.IdentityFluentImpl;
import io.fabric8.openshift.api.model.IdentityBuilder;

public class BaseKubernetesListFluentImpl<A extends BaseKubernetesListFluent<A>> extends BaseFluent<A> implements BaseKubernetesListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends HasMetadata,?>> items =  new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public BaseKubernetesListFluentImpl(){
    }
    public BaseKubernetesListFluentImpl(BaseKubernetesList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(HasMetadata... items){
            for (HasMetadata item : items) {if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof ThirdPartyResource){addToThirdPartyResourceItems((ThirdPartyResource)item);}
 else if (item instanceof Job){addToJobItems((Job)item);}
 else if (item instanceof Project){addToProjectItems((Project)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){addToBuildConfigItems((BuildConfig)item);}
 else if (item instanceof Route){addToRouteItems((Route)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestItems((ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateItems((Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof ClusterRole){addToClusterRoleItems((ClusterRole)item);}
 else if (item instanceof Scale){addToScaleItems((Scale)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof Ingress){addToIngressItems((Ingress)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){addToRoleBindingItems((RoleBinding)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof Image){addToImageItems((Image)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){addToReplicaSetItems((ReplicaSet)item);}
 else if (item instanceof Role){addToRoleItems((Role)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems((ConfigMap)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof DaemonSet){addToDaemonSetItems((DaemonSet)item);}
 else if (item instanceof Deployment){addToDeploymentItems((Deployment)item);}
 else if (item instanceof User){addToUserItems((User)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Build){addToBuildItems((Build)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagItems((ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupItems((Group)item);}
 else if (item instanceof PetSet){addToPetSetItems((PetSet)item);}
 else if (item instanceof Policy){addToPolicyItems((Policy)item);}
 else if (item instanceof ImageSignature){addToImageSignatureItems((ImageSignature)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof BuildRequest){addToBuildRequestItems((BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ImageStream){addToImageStreamItems((ImageStream)item);}
 else if (item instanceof HorizontalPodAutoscaler){addToHorizontalPodAutoscalerItems((HorizontalPodAutoscaler)item);}
 else if (item instanceof OAuthClient){addToOAuthClientItems((OAuthClient)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Identity){addToIdentityItems((Identity)item);}
} return (A)this;
    }

    public A removeFromItems(HasMetadata... items){
            for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof ThirdPartyResource){removeFromThirdPartyResourceItems((ThirdPartyResource)item);}
 else if (item instanceof Job){removeFromJobItems((Job)item);}
 else if (item instanceof Project){removeFromProjectItems((Project)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigItems((BuildConfig)item);}
 else if (item instanceof Route){removeFromRouteItems((Route)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestItems((ProjectRequest)item);}
 else if (item instanceof Template){removeFromTemplateItems((Template)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){removeFromPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleItems((ClusterRole)item);}
 else if (item instanceof Scale){removeFromScaleItems((Scale)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof Ingress){removeFromIngressItems((Ingress)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingItems((RoleBinding)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof Image){removeFromImageItems((Image)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){removeFromReplicaSetItems((ReplicaSet)item);}
 else if (item instanceof Role){removeFromRoleItems((Role)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof ConfigMap){removeFromConfigMapItems((ConfigMap)item);}
 else if (item instanceof ClusterPolicy){removeFromClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof DaemonSet){removeFromDaemonSetItems((DaemonSet)item);}
 else if (item instanceof Deployment){removeFromDeploymentItems((Deployment)item);}
 else if (item instanceof User){removeFromUserItems((User)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Build){removeFromBuildItems((Build)item);}
 else if (item instanceof ImageStreamTag){removeFromImageStreamTagItems((ImageStreamTag)item);}
 else if (item instanceof Group){removeFromGroupItems((Group)item);}
 else if (item instanceof PetSet){removeFromPetSetItems((PetSet)item);}
 else if (item instanceof Policy){removeFromPolicyItems((Policy)item);}
 else if (item instanceof ImageSignature){removeFromImageSignatureItems((ImageSignature)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestItems((BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){removeFromClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ImageStream){removeFromImageStreamItems((ImageStream)item);}
 else if (item instanceof HorizontalPodAutoscaler){removeFromHorizontalPodAutoscalerItems((HorizontalPodAutoscaler)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientItems((OAuthClient)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Identity){removeFromIdentityItems((Identity)item);}
} return (A)this;
    }

    public List<HasMetadata> getItems(){
            return build(items);
    }

    public A withItems(List<HasMetadata> items){
            this.items.clear();
            if (items != null) {for (HasMetadata item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(HasMetadata... items){
            this.items.clear(); if (items != null) {for (HasMetadata item :items){ this.addToItems(item);}} return (A) this;
    }

    public A addToLimitRangeItems(LimitRange... items){
            for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromLimitRangeItems(LimitRange... items){
            for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem(){
            return new LimitRangeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(LimitRange item){
            return new LimitRangeItemsNestedImpl(item);
    }

    public A addToThirdPartyResourceItems(ThirdPartyResource... items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromThirdPartyResourceItems(ThirdPartyResource... items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ThirdPartyResourceItemsNested<A> addNewThirdPartyResourceItem(){
            return new ThirdPartyResourceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ThirdPartyResourceItemsNested<A> addNewThirdPartyResourceItemLike(ThirdPartyResource item){
            return new ThirdPartyResourceItemsNestedImpl(item);
    }

    public A addToJobItems(Job... items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromJobItems(Job... items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.JobItemsNested<A> addNewJobItem(){
            return new JobItemsNestedImpl();
    }

    public BaseKubernetesListFluent.JobItemsNested<A> addNewJobItemLike(Job item){
            return new JobItemsNestedImpl(item);
    }

    public A addToProjectItems(Project... items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromProjectItems(Project... items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ProjectItemsNested<A> addNewProjectItem(){
            return new ProjectItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ProjectItemsNested<A> addNewProjectItemLike(Project item){
            return new ProjectItemsNestedImpl(item);
    }

    public A addToSecurityContextConstraintsItems(SecurityContextConstraints... items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromSecurityContextConstraintsItems(SecurityContextConstraints... items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<A> addNewSecurityContextConstraintsItem(){
            return new SecurityContextConstraintsItemsNestedImpl();
    }

    public BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<A> addNewSecurityContextConstraintsItemLike(SecurityContextConstraints item){
            return new SecurityContextConstraintsItemsNestedImpl(item);
    }

    public A addToBuildConfigItems(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBuildConfigItems(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.BuildConfigItemsNested<A> addNewBuildConfigItem(){
            return new BuildConfigItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BuildConfigItemsNested<A> addNewBuildConfigItemLike(BuildConfig item){
            return new BuildConfigItemsNestedImpl(item);
    }

    public A addToRouteItems(Route... items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromRouteItems(Route... items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.RouteItemsNested<A> addNewRouteItem(){
            return new RouteItemsNestedImpl();
    }

    public BaseKubernetesListFluent.RouteItemsNested<A> addNewRouteItemLike(Route item){
            return new RouteItemsNestedImpl(item);
    }

    public A addToOAuthAuthorizeTokenItems(OAuthAuthorizeToken... items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromOAuthAuthorizeTokenItems(OAuthAuthorizeToken... items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<A> addNewOAuthAuthorizeTokenItem(){
            return new OAuthAuthorizeTokenItemsNestedImpl();
    }

    public BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<A> addNewOAuthAuthorizeTokenItemLike(OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenItemsNestedImpl(item);
    }

    public A addToNamespaceItems(Namespace... items){
            for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromNamespaceItems(Namespace... items){
            for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem(){
            return new NamespaceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(Namespace item){
            return new NamespaceItemsNestedImpl(item);
    }

    public A addToClusterRoleBindingItems(ClusterRoleBinding... items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleBindingItems(ClusterRoleBinding... items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ClusterRoleBindingItemsNested<A> addNewClusterRoleBindingItem(){
            return new ClusterRoleBindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ClusterRoleBindingItemsNested<A> addNewClusterRoleBindingItemLike(ClusterRoleBinding item){
            return new ClusterRoleBindingItemsNestedImpl(item);
    }

    public A addToServiceItems(Service... items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromServiceItems(Service... items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem(){
            return new ServiceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(Service item){
            return new ServiceItemsNestedImpl(item);
    }

    public A addToReplicationControllerItems(ReplicationController... items){
            for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromReplicationControllerItems(ReplicationController... items){
            for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem(){
            return new ReplicationControllerItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(ReplicationController item){
            return new ReplicationControllerItemsNestedImpl(item);
    }

    public A addToProjectRequestItems(ProjectRequest... items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromProjectRequestItems(ProjectRequest... items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ProjectRequestItemsNested<A> addNewProjectRequestItem(){
            return new ProjectRequestItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ProjectRequestItemsNested<A> addNewProjectRequestItemLike(ProjectRequest item){
            return new ProjectRequestItemsNestedImpl(item);
    }

    public A addToTemplateItems(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromTemplateItems(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.TemplateItemsNested<A> addNewTemplateItem(){
            return new TemplateItemsNestedImpl();
    }

    public BaseKubernetesListFluent.TemplateItemsNested<A> addNewTemplateItemLike(Template item){
            return new TemplateItemsNestedImpl(item);
    }

    public A addToOAuthClientAuthorizationItems(OAuthClientAuthorization... items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromOAuthClientAuthorizationItems(OAuthClientAuthorization... items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<A> addNewOAuthClientAuthorizationItem(){
            return new OAuthClientAuthorizationItemsNestedImpl();
    }

    public BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<A> addNewOAuthClientAuthorizationItemLike(OAuthClientAuthorization item){
            return new OAuthClientAuthorizationItemsNestedImpl(item);
    }

    public A addToPolicyBindingItems(PolicyBinding... items){
            for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPolicyBindingItems(PolicyBinding... items){
            for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PolicyBindingItemsNested<A> addNewPolicyBindingItem(){
            return new PolicyBindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PolicyBindingItemsNested<A> addNewPolicyBindingItemLike(PolicyBinding item){
            return new PolicyBindingItemsNestedImpl(item);
    }

    public A addToClusterRoleItems(ClusterRole... items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleItems(ClusterRole... items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ClusterRoleItemsNested<A> addNewClusterRoleItem(){
            return new ClusterRoleItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ClusterRoleItemsNested<A> addNewClusterRoleItemLike(ClusterRole item){
            return new ClusterRoleItemsNestedImpl(item);
    }

    public A addToScaleItems(Scale... items){
            for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromScaleItems(Scale... items){
            for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ScaleItemsNested<A> addNewScaleItem(){
            return new ScaleItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ScaleItemsNested<A> addNewScaleItemLike(Scale item){
            return new ScaleItemsNestedImpl(item);
    }

    public A addToPodTemplateItems(PodTemplate... items){
            for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPodTemplateItems(PodTemplate... items){
            for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem(){
            return new PodTemplateItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(PodTemplate item){
            return new PodTemplateItemsNestedImpl(item);
    }

    public A addToEventItems(Event... items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromEventItems(Event... items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItem(){
            return new EventItemsNestedImpl();
    }

    public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItemLike(Event item){
            return new EventItemsNestedImpl(item);
    }

    public A addToIngressItems(Ingress... items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromIngressItems(Ingress... items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.IngressItemsNested<A> addNewIngressItem(){
            return new IngressItemsNestedImpl();
    }

    public BaseKubernetesListFluent.IngressItemsNested<A> addNewIngressItemLike(Ingress item){
            return new IngressItemsNestedImpl(item);
    }

    public A addToDeploymentConfigItems(DeploymentConfig... items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromDeploymentConfigItems(DeploymentConfig... items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.DeploymentConfigItemsNested<A> addNewDeploymentConfigItem(){
            return new DeploymentConfigItemsNestedImpl();
    }

    public BaseKubernetesListFluent.DeploymentConfigItemsNested<A> addNewDeploymentConfigItemLike(DeploymentConfig item){
            return new DeploymentConfigItemsNestedImpl(item);
    }

    public A addToOAuthAccessTokenItems(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromOAuthAccessTokenItems(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.OAuthAccessTokenItemsNested<A> addNewOAuthAccessTokenItem(){
            return new OAuthAccessTokenItemsNestedImpl();
    }

    public BaseKubernetesListFluent.OAuthAccessTokenItemsNested<A> addNewOAuthAccessTokenItemLike(OAuthAccessToken item){
            return new OAuthAccessTokenItemsNestedImpl(item);
    }

    public A addToRoleBindingItems(RoleBinding... items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromRoleBindingItems(RoleBinding... items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.RoleBindingItemsNested<A> addNewRoleBindingItem(){
            return new RoleBindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.RoleBindingItemsNested<A> addNewRoleBindingItemLike(RoleBinding item){
            return new RoleBindingItemsNestedImpl(item);
    }

    public A addToPersistentVolumeItems(PersistentVolume... items){
            for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeItems(PersistentVolume... items){
            for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem(){
            return new PersistentVolumeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(PersistentVolume item){
            return new PersistentVolumeItemsNestedImpl(item);
    }

    public A addToImageItems(Image... items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromImageItems(Image... items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ImageItemsNested<A> addNewImageItem(){
            return new ImageItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ImageItemsNested<A> addNewImageItemLike(Image item){
            return new ImageItemsNestedImpl(item);
    }

    public A addToPersistentVolumeClaimItems(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeClaimItems(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem(){
            return new PersistentVolumeClaimItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(PersistentVolumeClaim item){
            return new PersistentVolumeClaimItemsNestedImpl(item);
    }

    public A addToReplicaSetItems(ReplicaSet... items){
            for (ReplicaSet item : items) {ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromReplicaSetItems(ReplicaSet... items){
            for (ReplicaSet item : items) {ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ReplicaSetItemsNested<A> addNewReplicaSetItem(){
            return new ReplicaSetItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ReplicaSetItemsNested<A> addNewReplicaSetItemLike(ReplicaSet item){
            return new ReplicaSetItemsNestedImpl(item);
    }

    public A addToRoleItems(Role... items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromRoleItems(Role... items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.RoleItemsNested<A> addNewRoleItem(){
            return new RoleItemsNestedImpl();
    }

    public BaseKubernetesListFluent.RoleItemsNested<A> addNewRoleItemLike(Role item){
            return new RoleItemsNestedImpl(item);
    }

    public A addToEndpointsItems(Endpoints... items){
            for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromEndpointsItems(Endpoints... items){
            for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem(){
            return new EndpointsItemsNestedImpl();
    }

    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(Endpoints item){
            return new EndpointsItemsNestedImpl(item);
    }

    public A addToPodItems(Pod... items){
            for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPodItems(Pod... items){
            for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem(){
            return new PodItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(Pod item){
            return new PodItemsNestedImpl(item);
    }

    public A addToConfigMapItems(ConfigMap... items){
            for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromConfigMapItems(ConfigMap... items){
            for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem(){
            return new ConfigMapItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(ConfigMap item){
            return new ConfigMapItemsNestedImpl(item);
    }

    public A addToClusterPolicyItems(ClusterPolicy... items){
            for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromClusterPolicyItems(ClusterPolicy... items){
            for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ClusterPolicyItemsNested<A> addNewClusterPolicyItem(){
            return new ClusterPolicyItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ClusterPolicyItemsNested<A> addNewClusterPolicyItemLike(ClusterPolicy item){
            return new ClusterPolicyItemsNestedImpl(item);
    }

    public A addToDaemonSetItems(DaemonSet... items){
            for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromDaemonSetItems(DaemonSet... items){
            for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.DaemonSetItemsNested<A> addNewDaemonSetItem(){
            return new DaemonSetItemsNestedImpl();
    }

    public BaseKubernetesListFluent.DaemonSetItemsNested<A> addNewDaemonSetItemLike(DaemonSet item){
            return new DaemonSetItemsNestedImpl(item);
    }

    public A addToDeploymentItems(Deployment... items){
            for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromDeploymentItems(Deployment... items){
            for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.DeploymentItemsNested<A> addNewDeploymentItem(){
            return new DeploymentItemsNestedImpl();
    }

    public BaseKubernetesListFluent.DeploymentItemsNested<A> addNewDeploymentItemLike(Deployment item){
            return new DeploymentItemsNestedImpl(item);
    }

    public A addToUserItems(User... items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromUserItems(User... items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.UserItemsNested<A> addNewUserItem(){
            return new UserItemsNestedImpl();
    }

    public BaseKubernetesListFluent.UserItemsNested<A> addNewUserItemLike(User item){
            return new UserItemsNestedImpl(item);
    }

    public A addToComponentStatusItems(ComponentStatus... items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromComponentStatusItems(ComponentStatus... items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem(){
            return new ComponentStatusItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(ComponentStatus item){
            return new ComponentStatusItemsNestedImpl(item);
    }

    public A addToBuildItems(Build... items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBuildItems(Build... items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.BuildItemsNested<A> addNewBuildItem(){
            return new BuildItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BuildItemsNested<A> addNewBuildItemLike(Build item){
            return new BuildItemsNestedImpl(item);
    }

    public A addToImageStreamTagItems(ImageStreamTag... items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromImageStreamTagItems(ImageStreamTag... items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ImageStreamTagItemsNested<A> addNewImageStreamTagItem(){
            return new ImageStreamTagItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ImageStreamTagItemsNested<A> addNewImageStreamTagItemLike(ImageStreamTag item){
            return new ImageStreamTagItemsNestedImpl(item);
    }

    public A addToGroupItems(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromGroupItems(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.GroupItemsNested<A> addNewGroupItem(){
            return new GroupItemsNestedImpl();
    }

    public BaseKubernetesListFluent.GroupItemsNested<A> addNewGroupItemLike(Group item){
            return new GroupItemsNestedImpl(item);
    }

    public A addToPetSetItems(PetSet... items){
            for (PetSet item : items) {PetSetBuilder builder = new PetSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPetSetItems(PetSet... items){
            for (PetSet item : items) {PetSetBuilder builder = new PetSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PetSetItemsNested<A> addNewPetSetItem(){
            return new PetSetItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PetSetItemsNested<A> addNewPetSetItemLike(PetSet item){
            return new PetSetItemsNestedImpl(item);
    }

    public A addToPolicyItems(Policy... items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPolicyItems(Policy... items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PolicyItemsNested<A> addNewPolicyItem(){
            return new PolicyItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PolicyItemsNested<A> addNewPolicyItemLike(Policy item){
            return new PolicyItemsNestedImpl(item);
    }

    public A addToImageSignatureItems(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromImageSignatureItems(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ImageSignatureItemsNested<A> addNewImageSignatureItem(){
            return new ImageSignatureItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ImageSignatureItemsNested<A> addNewImageSignatureItemLike(ImageSignature item){
            return new ImageSignatureItemsNestedImpl(item);
    }

    public A addToBindingItems(Binding... items){
            for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBindingItems(Binding... items){
            for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem(){
            return new BindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(Binding item){
            return new BindingItemsNestedImpl(item);
    }

    public A addToResourceQuotaItems(ResourceQuota... items){
            for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromResourceQuotaItems(ResourceQuota... items){
            for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem(){
            return new ResourceQuotaItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(ResourceQuota item){
            return new ResourceQuotaItemsNestedImpl(item);
    }

    public A addToSecretItems(Secret... items){
            for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromSecretItems(Secret... items){
            for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem(){
            return new SecretItemsNestedImpl();
    }

    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(Secret item){
            return new SecretItemsNestedImpl(item);
    }

    public A addToBuildRequestItems(BuildRequest... items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBuildRequestItems(BuildRequest... items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.BuildRequestItemsNested<A> addNewBuildRequestItem(){
            return new BuildRequestItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BuildRequestItemsNested<A> addNewBuildRequestItemLike(BuildRequest item){
            return new BuildRequestItemsNestedImpl(item);
    }

    public A addToClusterPolicyBindingItems(ClusterPolicyBinding... items){
            for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromClusterPolicyBindingItems(ClusterPolicyBinding... items){
            for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<A> addNewClusterPolicyBindingItem(){
            return new ClusterPolicyBindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<A> addNewClusterPolicyBindingItemLike(ClusterPolicyBinding item){
            return new ClusterPolicyBindingItemsNestedImpl(item);
    }

    public A addToNodeItems(Node... items){
            for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromNodeItems(Node... items){
            for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem(){
            return new NodeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(Node item){
            return new NodeItemsNestedImpl(item);
    }

    public A addToImageStreamItems(ImageStream... items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromImageStreamItems(ImageStream... items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ImageStreamItemsNested<A> addNewImageStreamItem(){
            return new ImageStreamItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ImageStreamItemsNested<A> addNewImageStreamItemLike(ImageStream item){
            return new ImageStreamItemsNestedImpl(item);
    }

    public A addToHorizontalPodAutoscalerItems(HorizontalPodAutoscaler... items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromHorizontalPodAutoscalerItems(HorizontalPodAutoscaler... items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<A> addNewHorizontalPodAutoscalerItem(){
            return new HorizontalPodAutoscalerItemsNestedImpl();
    }

    public BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<A> addNewHorizontalPodAutoscalerItemLike(HorizontalPodAutoscaler item){
            return new HorizontalPodAutoscalerItemsNestedImpl(item);
    }

    public A addToOAuthClientItems(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromOAuthClientItems(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.OAuthClientItemsNested<A> addNewOAuthClientItem(){
            return new OAuthClientItemsNestedImpl();
    }

    public BaseKubernetesListFluent.OAuthClientItemsNested<A> addNewOAuthClientItemLike(OAuthClient item){
            return new OAuthClientItemsNestedImpl(item);
    }

    public A addToServiceAccountItems(ServiceAccount... items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromServiceAccountItems(ServiceAccount... items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem(){
            return new ServiceAccountItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(ServiceAccount item){
            return new ServiceAccountItemsNestedImpl(item);
    }

    public A addToIdentityItems(Identity... items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromIdentityItems(Identity... items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.IdentityItemsNested<A> addNewIdentityItem(){
            return new IdentityItemsNestedImpl();
    }

    public BaseKubernetesListFluent.IdentityItemsNested<A> addNewIdentityItemLike(Identity item){
            return new IdentityItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public BaseKubernetesListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BaseKubernetesListFluentImpl that = (BaseKubernetesListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class LimitRangeItemsNestedImpl<N> extends LimitRangeFluentImpl<BaseKubernetesListFluent.LimitRangeItemsNested<N>> implements BaseKubernetesListFluent.LimitRangeItemsNested<N>,Nested<N>{

            private final LimitRangeBuilder builder;
    
            LimitRangeItemsNestedImpl(){
                    this.builder = new LimitRangeBuilder(this);
            }
            LimitRangeItemsNestedImpl(LimitRange item){
                    this.builder = new LimitRangeBuilder(this, item);
            }
    
    public N endLimitRangeItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToLimitRangeItems(builder.build());
    }

}
    public class ThirdPartyResourceItemsNestedImpl<N> extends ThirdPartyResourceFluentImpl<BaseKubernetesListFluent.ThirdPartyResourceItemsNested<N>> implements BaseKubernetesListFluent.ThirdPartyResourceItemsNested<N>,Nested<N>{

            private final ThirdPartyResourceBuilder builder;
    
            ThirdPartyResourceItemsNestedImpl(){
                    this.builder = new ThirdPartyResourceBuilder(this);
            }
            ThirdPartyResourceItemsNestedImpl(ThirdPartyResource item){
                    this.builder = new ThirdPartyResourceBuilder(this, item);
            }
    
    public N endThirdPartyResourceItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToThirdPartyResourceItems(builder.build());
    }

}
    public class JobItemsNestedImpl<N> extends JobFluentImpl<BaseKubernetesListFluent.JobItemsNested<N>> implements BaseKubernetesListFluent.JobItemsNested<N>,Nested<N>{

            private final JobBuilder builder;
    
            JobItemsNestedImpl(){
                    this.builder = new JobBuilder(this);
            }
            JobItemsNestedImpl(Job item){
                    this.builder = new JobBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToJobItems(builder.build());
    }
    public N endJobItem(){
            return and();
    }

}
    public class ProjectItemsNestedImpl<N> extends ProjectFluentImpl<BaseKubernetesListFluent.ProjectItemsNested<N>> implements BaseKubernetesListFluent.ProjectItemsNested<N>,Nested<N>{

            private final ProjectBuilder builder;
    
            ProjectItemsNestedImpl(){
                    this.builder = new ProjectBuilder(this);
            }
            ProjectItemsNestedImpl(Project item){
                    this.builder = new ProjectBuilder(this, item);
            }
    
    public N endProjectItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToProjectItems(builder.build());
    }

}
    public class SecurityContextConstraintsItemsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<N>> implements BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<N>,Nested<N>{

            private final SecurityContextConstraintsBuilder builder;
    
            SecurityContextConstraintsItemsNestedImpl(){
                    this.builder = new SecurityContextConstraintsBuilder(this);
            }
            SecurityContextConstraintsItemsNestedImpl(SecurityContextConstraints item){
                    this.builder = new SecurityContextConstraintsBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToSecurityContextConstraintsItems(builder.build());
    }
    public N endSecurityContextConstraintsItem(){
            return and();
    }

}
    public class BuildConfigItemsNestedImpl<N> extends BuildConfigFluentImpl<BaseKubernetesListFluent.BuildConfigItemsNested<N>> implements BaseKubernetesListFluent.BuildConfigItemsNested<N>,Nested<N>{

            private final BuildConfigBuilder builder;
    
            BuildConfigItemsNestedImpl(){
                    this.builder = new BuildConfigBuilder(this);
            }
            BuildConfigItemsNestedImpl(BuildConfig item){
                    this.builder = new BuildConfigBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToBuildConfigItems(builder.build());
    }
    public N endBuildConfigItem(){
            return and();
    }

}
    public class RouteItemsNestedImpl<N> extends RouteFluentImpl<BaseKubernetesListFluent.RouteItemsNested<N>> implements BaseKubernetesListFluent.RouteItemsNested<N>,Nested<N>{

            private final RouteBuilder builder;
    
            RouteItemsNestedImpl(){
                    this.builder = new RouteBuilder(this);
            }
            RouteItemsNestedImpl(Route item){
                    this.builder = new RouteBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToRouteItems(builder.build());
    }
    public N endRouteItem(){
            return and();
    }

}
    public class OAuthAuthorizeTokenItemsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<N>> implements BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<N>,Nested<N>{

            private final OAuthAuthorizeTokenBuilder builder;
    
            OAuthAuthorizeTokenItemsNestedImpl(){
                    this.builder = new OAuthAuthorizeTokenBuilder(this);
            }
            OAuthAuthorizeTokenItemsNestedImpl(OAuthAuthorizeToken item){
                    this.builder = new OAuthAuthorizeTokenBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToOAuthAuthorizeTokenItems(builder.build());
    }
    public N endOAuthAuthorizeTokenItem(){
            return and();
    }

}
    public class NamespaceItemsNestedImpl<N> extends NamespaceFluentImpl<BaseKubernetesListFluent.NamespaceItemsNested<N>> implements BaseKubernetesListFluent.NamespaceItemsNested<N>,Nested<N>{

            private final NamespaceBuilder builder;
    
            NamespaceItemsNestedImpl(){
                    this.builder = new NamespaceBuilder(this);
            }
            NamespaceItemsNestedImpl(Namespace item){
                    this.builder = new NamespaceBuilder(this, item);
            }
    
    public N endNamespaceItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToNamespaceItems(builder.build());
    }

}
    public class ClusterRoleBindingItemsNestedImpl<N> extends ClusterRoleBindingFluentImpl<BaseKubernetesListFluent.ClusterRoleBindingItemsNested<N>> implements BaseKubernetesListFluent.ClusterRoleBindingItemsNested<N>,Nested<N>{

            private final ClusterRoleBindingBuilder builder;
    
            ClusterRoleBindingItemsNestedImpl(){
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
            ClusterRoleBindingItemsNestedImpl(ClusterRoleBinding item){
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
    
    public N endClusterRoleBindingItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToClusterRoleBindingItems(builder.build());
    }

}
    public class ServiceItemsNestedImpl<N> extends ServiceFluentImpl<BaseKubernetesListFluent.ServiceItemsNested<N>> implements BaseKubernetesListFluent.ServiceItemsNested<N>,Nested<N>{

            private final ServiceBuilder builder;
    
            ServiceItemsNestedImpl(Service item){
                    this.builder = new ServiceBuilder(this, item);
            }
            ServiceItemsNestedImpl(){
                    this.builder = new ServiceBuilder(this);
            }
    
    public N endServiceItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToServiceItems(builder.build());
    }

}
    public class ReplicationControllerItemsNestedImpl<N> extends ReplicationControllerFluentImpl<BaseKubernetesListFluent.ReplicationControllerItemsNested<N>> implements BaseKubernetesListFluent.ReplicationControllerItemsNested<N>,Nested<N>{

            private final ReplicationControllerBuilder builder;
    
            ReplicationControllerItemsNestedImpl(){
                    this.builder = new ReplicationControllerBuilder(this);
            }
            ReplicationControllerItemsNestedImpl(ReplicationController item){
                    this.builder = new ReplicationControllerBuilder(this, item);
            }
    
    public N endReplicationControllerItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToReplicationControllerItems(builder.build());
    }

}
    public class ProjectRequestItemsNestedImpl<N> extends ProjectRequestFluentImpl<BaseKubernetesListFluent.ProjectRequestItemsNested<N>> implements BaseKubernetesListFluent.ProjectRequestItemsNested<N>,Nested<N>{

            private final ProjectRequestBuilder builder;
    
            ProjectRequestItemsNestedImpl(){
                    this.builder = new ProjectRequestBuilder(this);
            }
            ProjectRequestItemsNestedImpl(ProjectRequest item){
                    this.builder = new ProjectRequestBuilder(this, item);
            }
    
    public N endProjectRequestItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToProjectRequestItems(builder.build());
    }

}
    public class TemplateItemsNestedImpl<N> extends TemplateFluentImpl<BaseKubernetesListFluent.TemplateItemsNested<N>> implements BaseKubernetesListFluent.TemplateItemsNested<N>,Nested<N>{

            private final TemplateBuilder builder;
    
            TemplateItemsNestedImpl(){
                    this.builder = new TemplateBuilder(this);
            }
            TemplateItemsNestedImpl(Template item){
                    this.builder = new TemplateBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToTemplateItems(builder.build());
    }
    public N endTemplateItem(){
            return and();
    }

}
    public class OAuthClientAuthorizationItemsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<N>> implements BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<N>,Nested<N>{

            private final OAuthClientAuthorizationBuilder builder;
    
            OAuthClientAuthorizationItemsNestedImpl(){
                    this.builder = new OAuthClientAuthorizationBuilder(this);
            }
            OAuthClientAuthorizationItemsNestedImpl(OAuthClientAuthorization item){
                    this.builder = new OAuthClientAuthorizationBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToOAuthClientAuthorizationItems(builder.build());
    }
    public N endOAuthClientAuthorizationItem(){
            return and();
    }

}
    public class PolicyBindingItemsNestedImpl<N> extends PolicyBindingFluentImpl<BaseKubernetesListFluent.PolicyBindingItemsNested<N>> implements BaseKubernetesListFluent.PolicyBindingItemsNested<N>,Nested<N>{

            private final PolicyBindingBuilder builder;
    
            PolicyBindingItemsNestedImpl(){
                    this.builder = new PolicyBindingBuilder(this);
            }
            PolicyBindingItemsNestedImpl(PolicyBinding item){
                    this.builder = new PolicyBindingBuilder(this, item);
            }
    
    public N endPolicyBindingItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPolicyBindingItems(builder.build());
    }

}
    public class ClusterRoleItemsNestedImpl<N> extends ClusterRoleFluentImpl<BaseKubernetesListFluent.ClusterRoleItemsNested<N>> implements BaseKubernetesListFluent.ClusterRoleItemsNested<N>,Nested<N>{

            private final ClusterRoleBuilder builder;
    
            ClusterRoleItemsNestedImpl(){
                    this.builder = new ClusterRoleBuilder(this);
            }
            ClusterRoleItemsNestedImpl(ClusterRole item){
                    this.builder = new ClusterRoleBuilder(this, item);
            }
    
    public N endClusterRoleItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToClusterRoleItems(builder.build());
    }

}
    public class ScaleItemsNestedImpl<N> extends ScaleFluentImpl<BaseKubernetesListFluent.ScaleItemsNested<N>> implements BaseKubernetesListFluent.ScaleItemsNested<N>,Nested<N>{

            private final ScaleBuilder builder;
    
            ScaleItemsNestedImpl(){
                    this.builder = new ScaleBuilder(this);
            }
            ScaleItemsNestedImpl(Scale item){
                    this.builder = new ScaleBuilder(this, item);
            }
    
    public N endScaleItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToScaleItems(builder.build());
    }

}
    public class PodTemplateItemsNestedImpl<N> extends PodTemplateFluentImpl<BaseKubernetesListFluent.PodTemplateItemsNested<N>> implements BaseKubernetesListFluent.PodTemplateItemsNested<N>,Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodTemplateItemsNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
            PodTemplateItemsNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
    
    public N endPodTemplateItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPodTemplateItems(builder.build());
    }

}
    public class EventItemsNestedImpl<N> extends EventFluentImpl<BaseKubernetesListFluent.EventItemsNested<N>> implements BaseKubernetesListFluent.EventItemsNested<N>,Nested<N>{

            private final EventBuilder builder;
    
            EventItemsNestedImpl(Event item){
                    this.builder = new EventBuilder(this, item);
            }
            EventItemsNestedImpl(){
                    this.builder = new EventBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToEventItems(builder.build());
    }
    public N endEventItem(){
            return and();
    }

}
    public class IngressItemsNestedImpl<N> extends IngressFluentImpl<BaseKubernetesListFluent.IngressItemsNested<N>> implements BaseKubernetesListFluent.IngressItemsNested<N>,Nested<N>{

            private final IngressBuilder builder;
    
            IngressItemsNestedImpl(){
                    this.builder = new IngressBuilder(this);
            }
            IngressItemsNestedImpl(Ingress item){
                    this.builder = new IngressBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToIngressItems(builder.build());
    }
    public N endIngressItem(){
            return and();
    }

}
    public class DeploymentConfigItemsNestedImpl<N> extends DeploymentConfigFluentImpl<BaseKubernetesListFluent.DeploymentConfigItemsNested<N>> implements BaseKubernetesListFluent.DeploymentConfigItemsNested<N>,Nested<N>{

            private final DeploymentConfigBuilder builder;
    
            DeploymentConfigItemsNestedImpl(){
                    this.builder = new DeploymentConfigBuilder(this);
            }
            DeploymentConfigItemsNestedImpl(DeploymentConfig item){
                    this.builder = new DeploymentConfigBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToDeploymentConfigItems(builder.build());
    }
    public N endDeploymentConfigItem(){
            return and();
    }

}
    public class OAuthAccessTokenItemsNestedImpl<N> extends OAuthAccessTokenFluentImpl<BaseKubernetesListFluent.OAuthAccessTokenItemsNested<N>> implements BaseKubernetesListFluent.OAuthAccessTokenItemsNested<N>,Nested<N>{

            private final OAuthAccessTokenBuilder builder;
    
            OAuthAccessTokenItemsNestedImpl(){
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
            OAuthAccessTokenItemsNestedImpl(OAuthAccessToken item){
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToOAuthAccessTokenItems(builder.build());
    }
    public N endOAuthAccessTokenItem(){
            return and();
    }

}
    public class RoleBindingItemsNestedImpl<N> extends RoleBindingFluentImpl<BaseKubernetesListFluent.RoleBindingItemsNested<N>> implements BaseKubernetesListFluent.RoleBindingItemsNested<N>,Nested<N>{

            private final RoleBindingBuilder builder;
    
            RoleBindingItemsNestedImpl(){
                    this.builder = new RoleBindingBuilder(this);
            }
            RoleBindingItemsNestedImpl(RoleBinding item){
                    this.builder = new RoleBindingBuilder(this, item);
            }
    
    public N endRoleBindingItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToRoleBindingItems(builder.build());
    }

}
    public class PersistentVolumeItemsNestedImpl<N> extends PersistentVolumeFluentImpl<BaseKubernetesListFluent.PersistentVolumeItemsNested<N>> implements BaseKubernetesListFluent.PersistentVolumeItemsNested<N>,Nested<N>{

            private final PersistentVolumeBuilder builder;
    
            PersistentVolumeItemsNestedImpl(){
                    this.builder = new PersistentVolumeBuilder(this);
            }
            PersistentVolumeItemsNestedImpl(PersistentVolume item){
                    this.builder = new PersistentVolumeBuilder(this, item);
            }
    
    public N endPersistentVolumeItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPersistentVolumeItems(builder.build());
    }

}
    public class ImageItemsNestedImpl<N> extends ImageFluentImpl<BaseKubernetesListFluent.ImageItemsNested<N>> implements BaseKubernetesListFluent.ImageItemsNested<N>,Nested<N>{

            private final ImageBuilder builder;
    
            ImageItemsNestedImpl(){
                    this.builder = new ImageBuilder(this);
            }
            ImageItemsNestedImpl(Image item){
                    this.builder = new ImageBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToImageItems(builder.build());
    }
    public N endImageItem(){
            return and();
    }

}
    public class PersistentVolumeClaimItemsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>> implements BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>,Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
    
            PersistentVolumeClaimItemsNestedImpl(){
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
            PersistentVolumeClaimItemsNestedImpl(PersistentVolumeClaim item){
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
    
    public N endPersistentVolumeClaimItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPersistentVolumeClaimItems(builder.build());
    }

}
    public class ReplicaSetItemsNestedImpl<N> extends ReplicaSetFluentImpl<BaseKubernetesListFluent.ReplicaSetItemsNested<N>> implements BaseKubernetesListFluent.ReplicaSetItemsNested<N>,Nested<N>{

            private final ReplicaSetBuilder builder;
    
            ReplicaSetItemsNestedImpl(){
                    this.builder = new ReplicaSetBuilder(this);
            }
            ReplicaSetItemsNestedImpl(ReplicaSet item){
                    this.builder = new ReplicaSetBuilder(this, item);
            }
    
    public N endReplicaSetItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToReplicaSetItems(builder.build());
    }

}
    public class RoleItemsNestedImpl<N> extends RoleFluentImpl<BaseKubernetesListFluent.RoleItemsNested<N>> implements BaseKubernetesListFluent.RoleItemsNested<N>,Nested<N>{

            private final RoleBuilder builder;
    
            RoleItemsNestedImpl(){
                    this.builder = new RoleBuilder(this);
            }
            RoleItemsNestedImpl(Role item){
                    this.builder = new RoleBuilder(this, item);
            }
    
    public N endRoleItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToRoleItems(builder.build());
    }

}
    public class EndpointsItemsNestedImpl<N> extends EndpointsFluentImpl<BaseKubernetesListFluent.EndpointsItemsNested<N>> implements BaseKubernetesListFluent.EndpointsItemsNested<N>,Nested<N>{

            private final EndpointsBuilder builder;
    
            EndpointsItemsNestedImpl(){
                    this.builder = new EndpointsBuilder(this);
            }
            EndpointsItemsNestedImpl(Endpoints item){
                    this.builder = new EndpointsBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToEndpointsItems(builder.build());
    }
    public N endEndpointsItem(){
            return and();
    }

}
    public class PodItemsNestedImpl<N> extends PodFluentImpl<BaseKubernetesListFluent.PodItemsNested<N>> implements BaseKubernetesListFluent.PodItemsNested<N>,Nested<N>{

            private final PodBuilder builder;
    
            PodItemsNestedImpl(){
                    this.builder = new PodBuilder(this);
            }
            PodItemsNestedImpl(Pod item){
                    this.builder = new PodBuilder(this, item);
            }
    
    public N endPodItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPodItems(builder.build());
    }

}
    public class ConfigMapItemsNestedImpl<N> extends ConfigMapFluentImpl<BaseKubernetesListFluent.ConfigMapItemsNested<N>> implements BaseKubernetesListFluent.ConfigMapItemsNested<N>,Nested<N>{

            private final ConfigMapBuilder builder;
    
            ConfigMapItemsNestedImpl(){
                    this.builder = new ConfigMapBuilder(this);
            }
            ConfigMapItemsNestedImpl(ConfigMap item){
                    this.builder = new ConfigMapBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToConfigMapItems(builder.build());
    }
    public N endConfigMapItem(){
            return and();
    }

}
    public class ClusterPolicyItemsNestedImpl<N> extends ClusterPolicyFluentImpl<BaseKubernetesListFluent.ClusterPolicyItemsNested<N>> implements BaseKubernetesListFluent.ClusterPolicyItemsNested<N>,Nested<N>{

            private final ClusterPolicyBuilder builder;
    
            ClusterPolicyItemsNestedImpl(){
                    this.builder = new ClusterPolicyBuilder(this);
            }
            ClusterPolicyItemsNestedImpl(ClusterPolicy item){
                    this.builder = new ClusterPolicyBuilder(this, item);
            }
    
    public N endClusterPolicyItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToClusterPolicyItems(builder.build());
    }

}
    public class DaemonSetItemsNestedImpl<N> extends DaemonSetFluentImpl<BaseKubernetesListFluent.DaemonSetItemsNested<N>> implements BaseKubernetesListFluent.DaemonSetItemsNested<N>,Nested<N>{

            private final DaemonSetBuilder builder;
    
            DaemonSetItemsNestedImpl(){
                    this.builder = new DaemonSetBuilder(this);
            }
            DaemonSetItemsNestedImpl(DaemonSet item){
                    this.builder = new DaemonSetBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToDaemonSetItems(builder.build());
    }
    public N endDaemonSetItem(){
            return and();
    }

}
    public class DeploymentItemsNestedImpl<N> extends DeploymentFluentImpl<BaseKubernetesListFluent.DeploymentItemsNested<N>> implements BaseKubernetesListFluent.DeploymentItemsNested<N>,Nested<N>{

            private final DeploymentBuilder builder;
    
            DeploymentItemsNestedImpl(){
                    this.builder = new DeploymentBuilder(this);
            }
            DeploymentItemsNestedImpl(Deployment item){
                    this.builder = new DeploymentBuilder(this, item);
            }
    
    public N endDeploymentItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToDeploymentItems(builder.build());
    }

}
    public class UserItemsNestedImpl<N> extends UserFluentImpl<BaseKubernetesListFluent.UserItemsNested<N>> implements BaseKubernetesListFluent.UserItemsNested<N>,Nested<N>{

            private final UserBuilder builder;
    
            UserItemsNestedImpl(){
                    this.builder = new UserBuilder(this);
            }
            UserItemsNestedImpl(User item){
                    this.builder = new UserBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToUserItems(builder.build());
    }
    public N endUserItem(){
            return and();
    }

}
    public class ComponentStatusItemsNestedImpl<N> extends ComponentStatusFluentImpl<BaseKubernetesListFluent.ComponentStatusItemsNested<N>> implements BaseKubernetesListFluent.ComponentStatusItemsNested<N>,Nested<N>{

            private final ComponentStatusBuilder builder;
    
            ComponentStatusItemsNestedImpl(){
                    this.builder = new ComponentStatusBuilder(this);
            }
            ComponentStatusItemsNestedImpl(ComponentStatus item){
                    this.builder = new ComponentStatusBuilder(this, item);
            }
    
    public N endComponentStatusItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToComponentStatusItems(builder.build());
    }

}
    public class BuildItemsNestedImpl<N> extends BuildFluentImpl<BaseKubernetesListFluent.BuildItemsNested<N>> implements BaseKubernetesListFluent.BuildItemsNested<N>,Nested<N>{

            private final BuildBuilder builder;
    
            BuildItemsNestedImpl(Build item){
                    this.builder = new BuildBuilder(this, item);
            }
            BuildItemsNestedImpl(){
                    this.builder = new BuildBuilder(this);
            }
    
    public N endBuildItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToBuildItems(builder.build());
    }

}
    public class ImageStreamTagItemsNestedImpl<N> extends ImageStreamTagFluentImpl<BaseKubernetesListFluent.ImageStreamTagItemsNested<N>> implements BaseKubernetesListFluent.ImageStreamTagItemsNested<N>,Nested<N>{

            private final ImageStreamTagBuilder builder;
    
            ImageStreamTagItemsNestedImpl(){
                    this.builder = new ImageStreamTagBuilder(this);
            }
            ImageStreamTagItemsNestedImpl(ImageStreamTag item){
                    this.builder = new ImageStreamTagBuilder(this, item);
            }
    
    public N endImageStreamTagItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToImageStreamTagItems(builder.build());
    }

}
    public class GroupItemsNestedImpl<N> extends GroupFluentImpl<BaseKubernetesListFluent.GroupItemsNested<N>> implements BaseKubernetesListFluent.GroupItemsNested<N>,Nested<N>{

            private final GroupBuilder builder;
    
            GroupItemsNestedImpl(){
                    this.builder = new GroupBuilder(this);
            }
            GroupItemsNestedImpl(Group item){
                    this.builder = new GroupBuilder(this, item);
            }
    
    public N endGroupItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToGroupItems(builder.build());
    }

}
    public class PetSetItemsNestedImpl<N> extends PetSetFluentImpl<BaseKubernetesListFluent.PetSetItemsNested<N>> implements BaseKubernetesListFluent.PetSetItemsNested<N>,Nested<N>{

            private final PetSetBuilder builder;
    
            PetSetItemsNestedImpl(){
                    this.builder = new PetSetBuilder(this);
            }
            PetSetItemsNestedImpl(PetSet item){
                    this.builder = new PetSetBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPetSetItems(builder.build());
    }
    public N endPetSetItem(){
            return and();
    }

}
    public class PolicyItemsNestedImpl<N> extends PolicyFluentImpl<BaseKubernetesListFluent.PolicyItemsNested<N>> implements BaseKubernetesListFluent.PolicyItemsNested<N>,Nested<N>{

            private final PolicyBuilder builder;
    
            PolicyItemsNestedImpl(){
                    this.builder = new PolicyBuilder(this);
            }
            PolicyItemsNestedImpl(Policy item){
                    this.builder = new PolicyBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToPolicyItems(builder.build());
    }
    public N endPolicyItem(){
            return and();
    }

}
    public class ImageSignatureItemsNestedImpl<N> extends ImageSignatureFluentImpl<BaseKubernetesListFluent.ImageSignatureItemsNested<N>> implements BaseKubernetesListFluent.ImageSignatureItemsNested<N>,Nested<N>{

            private final ImageSignatureBuilder builder;
    
            ImageSignatureItemsNestedImpl(){
                    this.builder = new ImageSignatureBuilder(this);
            }
            ImageSignatureItemsNestedImpl(ImageSignature item){
                    this.builder = new ImageSignatureBuilder(this, item);
            }
    
    public N endImageSignatureItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToImageSignatureItems(builder.build());
    }

}
    public class BindingItemsNestedImpl<N> extends BindingFluentImpl<BaseKubernetesListFluent.BindingItemsNested<N>> implements BaseKubernetesListFluent.BindingItemsNested<N>,Nested<N>{

            private final BindingBuilder builder;
    
            BindingItemsNestedImpl(){
                    this.builder = new BindingBuilder(this);
            }
            BindingItemsNestedImpl(Binding item){
                    this.builder = new BindingBuilder(this, item);
            }
    
    public N endBindingItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToBindingItems(builder.build());
    }

}
    public class ResourceQuotaItemsNestedImpl<N> extends ResourceQuotaFluentImpl<BaseKubernetesListFluent.ResourceQuotaItemsNested<N>> implements BaseKubernetesListFluent.ResourceQuotaItemsNested<N>,Nested<N>{

            private final ResourceQuotaBuilder builder;
    
            ResourceQuotaItemsNestedImpl(){
                    this.builder = new ResourceQuotaBuilder(this);
            }
            ResourceQuotaItemsNestedImpl(ResourceQuota item){
                    this.builder = new ResourceQuotaBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToResourceQuotaItems(builder.build());
    }
    public N endResourceQuotaItem(){
            return and();
    }

}
    public class SecretItemsNestedImpl<N> extends SecretFluentImpl<BaseKubernetesListFluent.SecretItemsNested<N>> implements BaseKubernetesListFluent.SecretItemsNested<N>,Nested<N>{

            private final SecretBuilder builder;
    
            SecretItemsNestedImpl(){
                    this.builder = new SecretBuilder(this);
            }
            SecretItemsNestedImpl(Secret item){
                    this.builder = new SecretBuilder(this, item);
            }
    
    public N endSecretItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToSecretItems(builder.build());
    }

}
    public class BuildRequestItemsNestedImpl<N> extends BuildRequestFluentImpl<BaseKubernetesListFluent.BuildRequestItemsNested<N>> implements BaseKubernetesListFluent.BuildRequestItemsNested<N>,Nested<N>{

            private final BuildRequestBuilder builder;
    
            BuildRequestItemsNestedImpl(){
                    this.builder = new BuildRequestBuilder(this);
            }
            BuildRequestItemsNestedImpl(BuildRequest item){
                    this.builder = new BuildRequestBuilder(this, item);
            }
    
    public N endBuildRequestItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToBuildRequestItems(builder.build());
    }

}
    public class ClusterPolicyBindingItemsNestedImpl<N> extends ClusterPolicyBindingFluentImpl<BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<N>> implements BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<N>,Nested<N>{

            private final ClusterPolicyBindingBuilder builder;
    
            ClusterPolicyBindingItemsNestedImpl(){
                    this.builder = new ClusterPolicyBindingBuilder(this);
            }
            ClusterPolicyBindingItemsNestedImpl(ClusterPolicyBinding item){
                    this.builder = new ClusterPolicyBindingBuilder(this, item);
            }
    
    public N endClusterPolicyBindingItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToClusterPolicyBindingItems(builder.build());
    }

}
    public class NodeItemsNestedImpl<N> extends NodeFluentImpl<BaseKubernetesListFluent.NodeItemsNested<N>> implements BaseKubernetesListFluent.NodeItemsNested<N>,Nested<N>{

            private final NodeBuilder builder;
    
            NodeItemsNestedImpl(){
                    this.builder = new NodeBuilder(this);
            }
            NodeItemsNestedImpl(Node item){
                    this.builder = new NodeBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToNodeItems(builder.build());
    }
    public N endNodeItem(){
            return and();
    }

}
    public class ImageStreamItemsNestedImpl<N> extends ImageStreamFluentImpl<BaseKubernetesListFluent.ImageStreamItemsNested<N>> implements BaseKubernetesListFluent.ImageStreamItemsNested<N>,Nested<N>{

            private final ImageStreamBuilder builder;
    
            ImageStreamItemsNestedImpl(ImageStream item){
                    this.builder = new ImageStreamBuilder(this, item);
            }
            ImageStreamItemsNestedImpl(){
                    this.builder = new ImageStreamBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToImageStreamItems(builder.build());
    }
    public N endImageStreamItem(){
            return and();
    }

}
    public class HorizontalPodAutoscalerItemsNestedImpl<N> extends HorizontalPodAutoscalerFluentImpl<BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<N>> implements BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<N>,Nested<N>{

            private final HorizontalPodAutoscalerBuilder builder;
    
            HorizontalPodAutoscalerItemsNestedImpl(){
                    this.builder = new HorizontalPodAutoscalerBuilder(this);
            }
            HorizontalPodAutoscalerItemsNestedImpl(HorizontalPodAutoscaler item){
                    this.builder = new HorizontalPodAutoscalerBuilder(this, item);
            }
    
    public N endHorizontalPodAutoscalerItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToHorizontalPodAutoscalerItems(builder.build());
    }

}
    public class OAuthClientItemsNestedImpl<N> extends OAuthClientFluentImpl<BaseKubernetesListFluent.OAuthClientItemsNested<N>> implements BaseKubernetesListFluent.OAuthClientItemsNested<N>,Nested<N>{

            private final OAuthClientBuilder builder;
    
            OAuthClientItemsNestedImpl(){
                    this.builder = new OAuthClientBuilder(this);
            }
            OAuthClientItemsNestedImpl(OAuthClient item){
                    this.builder = new OAuthClientBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToOAuthClientItems(builder.build());
    }
    public N endOAuthClientItem(){
            return and();
    }

}
    public class ServiceAccountItemsNestedImpl<N> extends ServiceAccountFluentImpl<BaseKubernetesListFluent.ServiceAccountItemsNested<N>> implements BaseKubernetesListFluent.ServiceAccountItemsNested<N>,Nested<N>{

            private final ServiceAccountBuilder builder;
    
            ServiceAccountItemsNestedImpl(){
                    this.builder = new ServiceAccountBuilder(this);
            }
            ServiceAccountItemsNestedImpl(ServiceAccount item){
                    this.builder = new ServiceAccountBuilder(this, item);
            }
    
    public N endServiceAccountItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToServiceAccountItems(builder.build());
    }

}
    public class IdentityItemsNestedImpl<N> extends IdentityFluentImpl<BaseKubernetesListFluent.IdentityItemsNested<N>> implements BaseKubernetesListFluent.IdentityItemsNested<N>,Nested<N>{

            private final IdentityBuilder builder;
    
            IdentityItemsNestedImpl(){
                    this.builder = new IdentityBuilder(this);
            }
            IdentityItemsNestedImpl(Identity item){
                    this.builder = new IdentityBuilder(this, item);
            }
    
    public N endIdentityItem(){
            return and();
    }
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.addToIdentityItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<BaseKubernetesListFluent.MetadataNested<N>> implements BaseKubernetesListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
