package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface RouteFluent<A extends RouteFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public RouteFluent.MetadataNested<A> withNewMetadata();
    public RouteFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RouteFluent.MetadataNested<A> editMetadata();
    public RouteSpec getSpec();
    public A withSpec(RouteSpec spec);
    public RouteFluent.SpecNested<A> withNewSpec();
    public RouteFluent.SpecNested<A> withNewSpecLike(RouteSpec item);
    public RouteFluent.SpecNested<A> editSpec();
    public RouteStatus getStatus();
    public A withStatus(RouteStatus status);
    public RouteFluent.StatusNested<A> withNewStatus();
    public RouteFluent.StatusNested<A> withNewStatusLike(RouteStatus item);
    public RouteFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<RouteFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,RouteSpecFluent<RouteFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,RouteStatusFluent<RouteFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
