package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public class OAuthAccessTokenListFluentImpl<A extends OAuthAccessTokenListFluent<A>> extends BaseFluent<A> implements OAuthAccessTokenListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends OAuthAccessToken,?>> items =  new ArrayList<VisitableBuilder<? extends OAuthAccessToken,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public OAuthAccessTokenListFluentImpl(){
    }
    public OAuthAccessTokenListFluentImpl(OAuthAccessTokenList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<OAuthAccessToken> getItems(){
            return build(items);
    }

    public A withItems(List<OAuthAccessToken> items){
            this.items.clear();
            if (items != null) {for (OAuthAccessToken item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(OAuthAccessToken... items){
            this.items.clear(); if (items != null) {for (OAuthAccessToken item :items){ this.addToItems(item);}} return (A) this;
    }

    public OAuthAccessTokenListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public OAuthAccessTokenListFluent.ItemsNested<A> addNewItemLike(OAuthAccessToken item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public OAuthAccessTokenListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public OAuthAccessTokenListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public OAuthAccessTokenListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OAuthAccessTokenListFluentImpl that = (OAuthAccessTokenListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends OAuthAccessTokenFluentImpl<OAuthAccessTokenListFluent.ItemsNested<N>> implements OAuthAccessTokenListFluent.ItemsNested<N>,Nested<N>{

            private final OAuthAccessTokenBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
            ItemsNestedImpl(OAuthAccessToken item){
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) OAuthAccessTokenListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<OAuthAccessTokenListFluent.MetadataNested<N>> implements OAuthAccessTokenListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) OAuthAccessTokenListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
