package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ImageStreamTagListFluent<A extends ImageStreamTagListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ImageStreamTag... items);
    public A removeFromItems(ImageStreamTag... items);
    public List<ImageStreamTag> getItems();
    public A withItems(List<ImageStreamTag> items);
    public A withItems(ImageStreamTag... items);
    public ImageStreamTagListFluent.ItemsNested<A> addNewItem();
    public ImageStreamTagListFluent.ItemsNested<A> addNewItemLike(ImageStreamTag item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ImageStreamTagListFluent.MetadataNested<A> withNewMetadata();
    public ImageStreamTagListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ImageStreamTagListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ImageStreamTagFluent<ImageStreamTagListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ImageStreamTagListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
