package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface GroupListFluent<A extends GroupListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Group... items);
    public A removeFromItems(Group... items);
    public List<Group> getItems();
    public A withItems(List<Group> items);
    public A withItems(Group... items);
    public GroupListFluent.ItemsNested<A> addNewItem();
    public GroupListFluent.ItemsNested<A> addNewItemLike(Group item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public GroupListFluent.MetadataNested<A> withNewMetadata();
    public GroupListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public GroupListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,GroupFluent<GroupListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<GroupListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
