package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder;

public interface IngressStatusFluent<A extends IngressStatusFluent<A>> extends Fluent<A>{


    public LoadBalancerStatus getLoadBalancer();
    public A withLoadBalancer(LoadBalancerStatus loadBalancer);
    public IngressStatusFluent.LoadBalancerNested<A> withNewLoadBalancer();
    public IngressStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStatus item);
    public IngressStatusFluent.LoadBalancerNested<A> editLoadBalancer();

    public interface LoadBalancerNested<N> extends Nested<N>,LoadBalancerStatusFluent<IngressStatusFluent.LoadBalancerNested<N>>{

        
    public N and();    public N endLoadBalancer();
}


}
