package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface HandlerFluent<A extends HandlerFluent<A>> extends Fluent<A>{


    public ExecAction getExec();
    public A withExec(ExecAction exec);
    public HandlerFluent.ExecNested<A> withNewExec();
    public HandlerFluent.ExecNested<A> withNewExecLike(ExecAction item);
    public HandlerFluent.ExecNested<A> editExec();
    public HTTPGetAction getHttpGet();
    public A withHttpGet(HTTPGetAction httpGet);
    public HandlerFluent.HttpGetNested<A> withNewHttpGet();
    public HandlerFluent.HttpGetNested<A> withNewHttpGetLike(HTTPGetAction item);
    public HandlerFluent.HttpGetNested<A> editHttpGet();
    public TCPSocketAction getTcpSocket();
    public A withTcpSocket(TCPSocketAction tcpSocket);
    public HandlerFluent.TcpSocketNested<A> withNewTcpSocket();
    public HandlerFluent.TcpSocketNested<A> withNewTcpSocketLike(TCPSocketAction item);
    public HandlerFluent.TcpSocketNested<A> editTcpSocket();

    public interface ExecNested<N> extends Nested<N>,ExecActionFluent<HandlerFluent.ExecNested<N>>{

        
    public N and();    public N endExec();
}
    public interface HttpGetNested<N> extends Nested<N>,HTTPGetActionFluent<HandlerFluent.HttpGetNested<N>>{

        
    public N endHttpGet();    public N and();
}
    public interface TcpSocketNested<N> extends Nested<N>,TCPSocketActionFluent<HandlerFluent.TcpSocketNested<N>>{

        
    public N and();    public N endTcpSocket();
}


}
