/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirementFluentImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LabelSelectorFluentImpl<A extends LabelSelectorFluent<A>>
extends BaseFluent<A>
implements LabelSelectorFluent<A> {
    private List<VisitableBuilder<? extends LabelSelectorRequirement, ?>> matchExpressions = new ArrayList();
    private Map<String, String> matchLabels = new LinkedHashMap<String, String>();

    public LabelSelectorFluentImpl() {
    }

    public LabelSelectorFluentImpl(LabelSelector instance) {
        this.withMatchExpressions(instance.getMatchExpressions());
        this.withMatchLabels(instance.getMatchLabels());
    }

    @Override
    public A addToMatchExpressions(LabelSelectorRequirement ... items) {
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchExpressions(LabelSelectorRequirement ... items) {
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<LabelSelectorRequirement> getMatchExpressions() {
        return LabelSelectorFluentImpl.build(this.matchExpressions);
    }

    @Override
    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
        this._visitables.removeAll(this.matchExpressions);
        this.matchExpressions.clear();
        if (matchExpressions != null) {
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withMatchExpressions(LabelSelectorRequirement ... matchExpressions) {
        this.matchExpressions.clear();
        if (matchExpressions != null) {
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    @Override
    public LabelSelectorFluent.ExtensionsMatchExpressionsNested<A> addNewExtensionsMatchExpression() {
        return new ExtensionsMatchExpressionsNestedImpl();
    }

    @Override
    public LabelSelectorFluent.ExtensionsMatchExpressionsNested<A> addNewMatchExpressionLike(LabelSelectorRequirement item) {
        return new ExtensionsMatchExpressionsNestedImpl(item);
    }

    @Override
    public A addToMatchLabels(String key, String value) {
        if (key != null && value != null) {
            this.matchLabels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMatchLabels(Map<String, String> map) {
        if (map != null) {
            this.matchLabels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabels(String key) {
        if (key != null) {
            this.matchLabels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.matchLabels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    @Override
    public A withMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels.clear();
        if (matchLabels != null) {
            this.matchLabels.putAll(matchLabels);
        }
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorFluentImpl that = (LabelSelectorFluentImpl)o;
        if (this.matchExpressions != null ? !this.matchExpressions.equals(that.matchExpressions) : that.matchExpressions != null) {
            return false;
        }
        return !(this.matchLabels != null ? !this.matchLabels.equals(that.matchLabels) : that.matchLabels != null);
    }

    public class ExtensionsMatchExpressionsNestedImpl<N>
    extends LabelSelectorRequirementFluentImpl<LabelSelectorFluent.ExtensionsMatchExpressionsNested<N>>
    implements LabelSelectorFluent.ExtensionsMatchExpressionsNested<N>,
    Nested<N> {
        private final LabelSelectorRequirementBuilder builder;

        ExtensionsMatchExpressionsNestedImpl(LabelSelectorRequirement item) {
            this.builder = new LabelSelectorRequirementBuilder(this, item);
        }

        ExtensionsMatchExpressionsNestedImpl() {
            this.builder = new LabelSelectorRequirementBuilder(this);
        }

        @Override
        public N and() {
            return (N)LabelSelectorFluentImpl.this.addToMatchExpressions(this.builder.build());
        }

        @Override
        public N endExtensionsMatchExpression() {
            return this.and();
        }
    }
}

