package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class RollingDeploymentStrategyParamsBuilder extends RollingDeploymentStrategyParamsFluentImpl<RollingDeploymentStrategyParamsBuilder> implements VisitableBuilder<RollingDeploymentStrategyParams,RollingDeploymentStrategyParamsBuilder>{

    RollingDeploymentStrategyParamsFluent<?> fluent;
    Boolean validationEnabled;

    public RollingDeploymentStrategyParamsBuilder(){
            this(true);
    }
    public RollingDeploymentStrategyParamsBuilder(Boolean validationEnabled){
            this(new RollingDeploymentStrategyParams(), validationEnabled);
    }
    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent){
            this(fluent, true);
    }
    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RollingDeploymentStrategyParams(), validationEnabled);
    }
    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent,RollingDeploymentStrategyParams instance){
            this(fluent, instance, true);
    }
    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent,RollingDeploymentStrategyParams instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIntervalSeconds(instance.getIntervalSeconds()); 
            fluent.withMaxSurge(instance.getMaxSurge()); 
            fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
            fluent.withPost(instance.getPost()); 
            fluent.withPre(instance.getPre()); 
            fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            fluent.withUpdatePercent(instance.getUpdatePercent()); 
            fluent.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
            this.validationEnabled = validationEnabled; 
    }
    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParams instance){
            this(instance,true);
    }
    public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParams instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIntervalSeconds(instance.getIntervalSeconds()); 
            this.withMaxSurge(instance.getMaxSurge()); 
            this.withMaxUnavailable(instance.getMaxUnavailable()); 
            this.withPost(instance.getPost()); 
            this.withPre(instance.getPre()); 
            this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            this.withUpdatePercent(instance.getUpdatePercent()); 
            this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
            this.validationEnabled = validationEnabled; 
    }

    public RollingDeploymentStrategyParams build(){
            RollingDeploymentStrategyParams buildable = new RollingDeploymentStrategyParams(fluent.getIntervalSeconds(),fluent.getMaxSurge(),fluent.getMaxUnavailable(),fluent.getPost(),fluent.getPre(),fluent.getTimeoutSeconds(),fluent.getUpdatePercent(),fluent.getUpdatePeriodSeconds());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RollingDeploymentStrategyParamsBuilder that = (RollingDeploymentStrategyParamsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
