package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ImageSourceFluent<A extends ImageSourceFluent<A>> extends Fluent<A>{


    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public ImageSourceFluent.FromNested<A> withNewFrom();
    public ImageSourceFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public ImageSourceFluent.FromNested<A> editFrom();
    public ImageSourceFluent.FromNested<A> editOrNewFrom();
    public ImageSourceFluent.FromNested<A> editOrNewFromLike(ObjectReference item);
    public A addToPaths(ImageSourcePath... items);
    public A removeFromPaths(ImageSourcePath... items);
    public List<ImageSourcePath> getPaths();
    public A withPaths(List<ImageSourcePath> paths);
    public A withPaths(ImageSourcePath... paths);
    public ImageSourceFluent.PathsNested<A> addNewPath();
    public ImageSourceFluent.PathsNested<A> addNewPathLike(ImageSourcePath item);
    public A addNewPath(String destinationDir,String sourcePath);
    public LocalObjectReference getPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecret();
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public ImageSourceFluent.PullSecretNested<A> editPullSecret();
    public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecret();
    public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
    public A withNewPullSecret(String name);

    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<ImageSourceFluent.FromNested<N>>{

        
    public N and();    public N endFrom();
}
    public interface PathsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSourcePathFluent<ImageSourceFluent.PathsNested<N>>{

        
    public N and();    public N endPath();
}
    public interface PullSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<ImageSourceFluent.PullSecretNested<N>>{

        
    public N and();    public N endPullSecret();
}


}
