package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ImageSignatureFluent<A extends ImageSignatureFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToConditions(SignatureCondition... items);
    public A removeFromConditions(SignatureCondition... items);
    public List<SignatureCondition> getConditions();
    public A withConditions(List<SignatureCondition> conditions);
    public A withConditions(SignatureCondition... conditions);
    public ImageSignatureFluent.ConditionsNested<A> addNewCondition();
    public ImageSignatureFluent.ConditionsNested<A> addNewConditionLike(SignatureCondition item);
    public String getContent();
    public A withContent(String content);
    public String getCreated();
    public A withCreated(String created);
    public String getImageIdentity();
    public A withImageIdentity(String imageIdentity);
    public SignatureIssuer getIssuedBy();
    public A withIssuedBy(SignatureIssuer issuedBy);
    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedBy();
    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedByLike(SignatureIssuer item);
    public ImageSignatureFluent.IssuedByNested<A> editIssuedBy();
    public ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedBy();
    public ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedByLike(SignatureIssuer item);
    public A withNewIssuedBy(String commonName,String organization);
    public SignatureSubject getIssuedTo();
    public A withIssuedTo(SignatureSubject issuedTo);
    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedTo();
    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedToLike(SignatureSubject item);
    public ImageSignatureFluent.IssuedToNested<A> editIssuedTo();
    public ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedTo();
    public ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedToLike(SignatureSubject item);
    public A withNewIssuedTo(String commonName,String organization,String publicKeyID);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ImageSignatureFluent.MetadataNested<A> withNewMetadata();
    public ImageSignatureFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageSignatureFluent.MetadataNested<A> editMetadata();
    public ImageSignatureFluent.MetadataNested<A> editOrNewMetadata();
    public ImageSignatureFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToSignedClaims(String key,String value);
    public A addToSignedClaims(Map<String,String> map);
    public A removeFromSignedClaims(String key);
    public A removeFromSignedClaims(Map<String,String> map);
    public Map<String,String> getSignedClaims();
    public A withSignedClaims(Map<String,String> signedClaims);
    public String getType();
    public A withType(String type);

    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SignatureConditionFluent<ImageSignatureFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface IssuedByNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SignatureIssuerFluent<ImageSignatureFluent.IssuedByNested<N>>{

        
    public N and();    public N endIssuedBy();
}
    public interface IssuedToNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SignatureSubjectFluent<ImageSignatureFluent.IssuedToNested<N>>{

        
    public N and();    public N endIssuedTo();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ImageSignatureFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
