package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ImageListFluent<A extends ImageListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Image... items);
    public A removeFromItems(Image... items);
    public List<Image> getItems();
    public A withItems(List<Image> items);
    public A withItems(Image... items);
    public ImageListFluent.ItemsNested<A> addNewItem();
    public ImageListFluent.ItemsNested<A> addNewItemLike(Image item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ImageListFluent.MetadataNested<A> withNewMetadata();
    public ImageListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ImageListFluent.MetadataNested<A> editMetadata();
    public ImageListFluent.MetadataNested<A> editOrNewMetadata();
    public ImageListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<ImageListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ImageListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
