package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.constraints.NotNull;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface DockerImageFluent<A extends DockerImageFluent<A>> extends Fluent<A>{


    public String getArchitecture();
    public A withArchitecture(String architecture);
    public String getAuthor();
    public A withAuthor(String author);
    public String getComment();
    public A withComment(String comment);
    public DockerConfig getConfig();
    public A withConfig(DockerConfig config);
    public DockerImageFluent.ConfigNested<A> withNewConfig();
    public DockerImageFluent.ConfigNested<A> withNewConfigLike(DockerConfig item);
    public DockerImageFluent.ConfigNested<A> editConfig();
    public DockerImageFluent.ConfigNested<A> editOrNewConfig();
    public DockerImageFluent.ConfigNested<A> editOrNewConfigLike(DockerConfig item);
    public String getContainer();
    public A withContainer(String container);
    public DockerConfig getContainerConfig();
    public A withContainerConfig(DockerConfig containerConfig);
    public DockerImageFluent.ContainerConfigNested<A> withNewContainerConfig();
    public DockerImageFluent.ContainerConfigNested<A> withNewContainerConfigLike(DockerConfig item);
    public DockerImageFluent.ContainerConfigNested<A> editContainerConfig();
    public DockerImageFluent.ContainerConfigNested<A> editOrNewContainerConfig();
    public DockerImageFluent.ContainerConfigNested<A> editOrNewContainerConfigLike(DockerConfig item);
    public String getCreated();
    public A withCreated(String created);
    public String getDockerVersion();
    public A withDockerVersion(String dockerVersion);
    public String getId();
    public A withId(String id);
    public String getParent();
    public A withParent(String parent);
    public Long getSize();
    public A withSize(Long size);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);

    public interface ConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DockerConfigFluent<DockerImageFluent.ConfigNested<N>>{

        
    public N and();    public N endConfig();
}
    public interface ContainerConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DockerConfigFluent<DockerImageFluent.ContainerConfigNested<N>>{

        
    public N and();    public N endContainerConfig();
}


}
