package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class DockerBuildStrategyBuilder extends DockerBuildStrategyFluentImpl<DockerBuildStrategyBuilder> implements VisitableBuilder<DockerBuildStrategy,DockerBuildStrategyBuilder>{

    DockerBuildStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public DockerBuildStrategyBuilder(){
            this(true);
    }
    public DockerBuildStrategyBuilder(Boolean validationEnabled){
            this(new DockerBuildStrategy(), validationEnabled);
    }
    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DockerBuildStrategy(), validationEnabled);
    }
    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent,DockerBuildStrategy instance){
            this(fluent, instance, true);
    }
    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent,DockerBuildStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDockerfilePath(instance.getDockerfilePath()); 
            fluent.withEnv(instance.getEnv()); 
            fluent.withForcePull(instance.getForcePull()); 
            fluent.withFrom(instance.getFrom()); 
            fluent.withNoCache(instance.getNoCache()); 
            fluent.withPullSecret(instance.getPullSecret()); 
            this.validationEnabled = validationEnabled; 
    }
    public DockerBuildStrategyBuilder(DockerBuildStrategy instance){
            this(instance,true);
    }
    public DockerBuildStrategyBuilder(DockerBuildStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDockerfilePath(instance.getDockerfilePath()); 
            this.withEnv(instance.getEnv()); 
            this.withForcePull(instance.getForcePull()); 
            this.withFrom(instance.getFrom()); 
            this.withNoCache(instance.getNoCache()); 
            this.withPullSecret(instance.getPullSecret()); 
            this.validationEnabled = validationEnabled; 
    }

    public DockerBuildStrategy build(){
            DockerBuildStrategy buildable = new DockerBuildStrategy(fluent.getDockerfilePath(),fluent.getEnv(),fluent.isForcePull(),fluent.getFrom(),fluent.isNoCache(),fluent.getPullSecret());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerBuildStrategyBuilder that = (DockerBuildStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
