package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class DeploymentStrategyBuilder extends io.fabric8.openshift.api.model.DeploymentStrategyFluentImpl<io.fabric8.openshift.api.model.DeploymentStrategyBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.DeploymentStrategy,io.fabric8.openshift.api.model.DeploymentStrategyBuilder>{

    io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentStrategyBuilder(){
            this(true);
    }
    public DeploymentStrategyBuilder(Boolean validationEnabled){
            this(new DeploymentStrategy(), validationEnabled);
    }
    public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DeploymentStrategy(), validationEnabled);
    }
    public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentStrategy instance){
            this(fluent, instance, true);
    }
    public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAnnotations(instance.getAnnotations()); 
            fluent.withCustomParams(instance.getCustomParams()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withRecreateParams(instance.getRecreateParams()); 
            fluent.withResources(instance.getResources()); 
            fluent.withRollingParams(instance.getRollingParams()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategy instance){
            this(instance,true);
    }
    public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAnnotations(instance.getAnnotations()); 
            this.withCustomParams(instance.getCustomParams()); 
            this.withLabels(instance.getLabels()); 
            this.withRecreateParams(instance.getRecreateParams()); 
            this.withResources(instance.getResources()); 
            this.withRollingParams(instance.getRollingParams()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.DeploymentStrategy build(){
            DeploymentStrategy buildable = new DeploymentStrategy(fluent.getAnnotations(),fluent.getCustomParams(),fluent.getLabels(),fluent.getRecreateParams(),fluent.getResources(),fluent.getRollingParams(),fluent.getType());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentStrategyBuilder that = (DeploymentStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
