package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import lombok.EqualsAndHashCode;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectReference;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import lombok.ToString;

public class BuildRequestFluentImpl<A extends BuildRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuildRequestFluent<A>{

    private String apiVersion;
    private VisitableBuilder<? extends BinaryBuildSource,?> binary;
    private List<VisitableBuilder<? extends EnvVar,?>> env =  new ArrayList<VisitableBuilder<? extends EnvVar,?>>();
    private VisitableBuilder<? extends ObjectReference,?> from;
    private String kind;
    private Long lastVersion;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends SourceRevision,?> revision;
    private List<VisitableBuilder<? extends BuildTriggerCause,?>> triggeredBy =  new ArrayList<VisitableBuilder<? extends BuildTriggerCause,?>>();
    private VisitableBuilder<? extends ObjectReference,?> triggeredByImage;

    public BuildRequestFluentImpl(){
    }
    public BuildRequestFluentImpl(BuildRequest instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withBinary(instance.getBinary()); 
            this.withEnv(instance.getEnv()); 
            this.withFrom(instance.getFrom()); 
            this.withKind(instance.getKind()); 
            this.withLastVersion(instance.getLastVersion()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRevision(instance.getRevision()); 
            this.withTriggeredBy(instance.getTriggeredBy()); 
            this.withTriggeredByImage(instance.getTriggeredByImage()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public BinaryBuildSource getBinary(){
            return this.binary!=null?this.binary.build():null;
    }

    public A withBinary(BinaryBuildSource binary){
            _visitables.remove(this.binary);
            if (binary!=null){ this.binary= new BinaryBuildSourceBuilder(binary); _visitables.add(this.binary);} return (A) this;
    }

    public BuildRequestFluent.BinaryNested<A> withNewBinary(){
            return new BinaryNestedImpl();
    }

    public BuildRequestFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item){
            return new BinaryNestedImpl(item);
    }

    public BuildRequestFluent.BinaryNested<A> editBinary(){
            return withNewBinaryLike(getBinary());
    }

    public BuildRequestFluent.BinaryNested<A> editOrNewBinary(){
            return withNewBinaryLike(getBinary() != null ? getBinary(): new BinaryBuildSourceBuilder().build());
    }

    public BuildRequestFluent.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item){
            return withNewBinaryLike(getBinary() != null ? getBinary(): item);
    }

    public A withNewBinary(String asFile){
            return (A)withBinary(new BinaryBuildSource(asFile));
    }

    public A addToEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (A)this;
    }

    public List<EnvVar> getEnv(){
            return build(env);
    }

    public A withEnv(List<EnvVar> env){
            _visitables.removeAll(this.env);
            this.env.clear();
            if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (A) this;
    }

    public A withEnv(EnvVar... env){
            this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public BuildRequestFluent.EnvNested<A> addNewEnv(){
            return new EnvNestedImpl();
    }

    public BuildRequestFluent.EnvNested<A> addNewEnvLike(EnvVar item){
            return new EnvNestedImpl(item);
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            _visitables.remove(this.from);
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public BuildRequestFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public BuildRequestFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public BuildRequestFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public BuildRequestFluent.FromNested<A> editOrNewFrom(){
            return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
    }

    public BuildRequestFluent.FromNested<A> editOrNewFromLike(ObjectReference item){
            return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Long getLastVersion(){
            return this.lastVersion;
    }

    public A withLastVersion(Long lastVersion){
            this.lastVersion=lastVersion; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public BuildRequestFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public BuildRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public BuildRequestFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public BuildRequestFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public BuildRequestFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public SourceRevision getRevision(){
            return this.revision!=null?this.revision.build():null;
    }

    public A withRevision(SourceRevision revision){
            _visitables.remove(this.revision);
            if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (A) this;
    }

    public BuildRequestFluent.RevisionNested<A> withNewRevision(){
            return new RevisionNestedImpl();
    }

    public BuildRequestFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item){
            return new RevisionNestedImpl(item);
    }

    public BuildRequestFluent.RevisionNested<A> editRevision(){
            return withNewRevisionLike(getRevision());
    }

    public BuildRequestFluent.RevisionNested<A> editOrNewRevision(){
            return withNewRevisionLike(getRevision() != null ? getRevision(): new SourceRevisionBuilder().build());
    }

    public BuildRequestFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item){
            return withNewRevisionLike(getRevision() != null ? getRevision(): item);
    }

    public A addToTriggeredBy(BuildTriggerCause... items){
            for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.add(builder);this.triggeredBy.add(builder);} return (A)this;
    }

    public A removeFromTriggeredBy(BuildTriggerCause... items){
            for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.remove(builder);this.triggeredBy.remove(builder);} return (A)this;
    }

    public List<BuildTriggerCause> getTriggeredBy(){
            return build(triggeredBy);
    }

    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy){
            _visitables.removeAll(this.triggeredBy);
            this.triggeredBy.clear();
            if (triggeredBy != null) {for (BuildTriggerCause item : triggeredBy){this.addToTriggeredBy(item);}} return (A) this;
    }

    public A withTriggeredBy(BuildTriggerCause... triggeredBy){
            this.triggeredBy.clear(); if (triggeredBy != null) {for (BuildTriggerCause item :triggeredBy){ this.addToTriggeredBy(item);}} return (A) this;
    }

    public BuildRequestFluent.TriggeredByNested<A> addNewTriggeredBy(){
            return new TriggeredByNestedImpl();
    }

    public BuildRequestFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item){
            return new TriggeredByNestedImpl(item);
    }

    public ObjectReference getTriggeredByImage(){
            return this.triggeredByImage!=null?this.triggeredByImage.build():null;
    }

    public A withTriggeredByImage(ObjectReference triggeredByImage){
            _visitables.remove(this.triggeredByImage);
            if (triggeredByImage!=null){ this.triggeredByImage= new ObjectReferenceBuilder(triggeredByImage); _visitables.add(this.triggeredByImage);} return (A) this;
    }

    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImage(){
            return new TriggeredByImageNestedImpl();
    }

    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImageLike(ObjectReference item){
            return new TriggeredByImageNestedImpl(item);
    }

    public BuildRequestFluent.TriggeredByImageNested<A> editTriggeredByImage(){
            return withNewTriggeredByImageLike(getTriggeredByImage());
    }

    public BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImage(){
            return withNewTriggeredByImageLike(getTriggeredByImage() != null ? getTriggeredByImage(): new ObjectReferenceBuilder().build());
    }

    public BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImageLike(ObjectReference item){
            return withNewTriggeredByImageLike(getTriggeredByImage() != null ? getTriggeredByImage(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildRequestFluentImpl that = (BuildRequestFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (binary != null ? !binary.equals(that.binary) :that.binary != null) return false;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (lastVersion != null ? !lastVersion.equals(that.lastVersion) :that.lastVersion != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
            if (triggeredBy != null ? !triggeredBy.equals(that.triggeredBy) :that.triggeredBy != null) return false;
            if (triggeredByImage != null ? !triggeredByImage.equals(that.triggeredByImage) :that.triggeredByImage != null) return false;
            return true;
    }


    public class BinaryNestedImpl<N> extends BinaryBuildSourceFluentImpl<BuildRequestFluent.BinaryNested<N>> implements BuildRequestFluent.BinaryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BinaryBuildSourceBuilder builder;
    
            BinaryNestedImpl(BinaryBuildSource item){
                    this.builder = new BinaryBuildSourceBuilder(this, item);
            }
            BinaryNestedImpl(){
                    this.builder = new BinaryBuildSourceBuilder(this);
            }
    
    public N and(){
            return (N) BuildRequestFluentImpl.this.withBinary(builder.build());
    }
    public N endBinary(){
            return and();
    }

}
    public class EnvNestedImpl<N> extends EnvVarFluentImpl<BuildRequestFluent.EnvNested<N>> implements BuildRequestFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EnvVarBuilder builder;
    
            EnvNestedImpl(EnvVar item){
                    this.builder = new EnvVarBuilder(this, item);
            }
            EnvNestedImpl(){
                    this.builder = new EnvVarBuilder(this);
            }
    
    public N and(){
            return (N) BuildRequestFluentImpl.this.addToEnv(builder.build());
    }
    public N endEnv(){
            return and();
    }

}
    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<BuildRequestFluent.FromNested<N>> implements BuildRequestFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) BuildRequestFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<BuildRequestFluent.MetadataNested<N>> implements BuildRequestFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) BuildRequestFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<BuildRequestFluent.RevisionNested<N>> implements BuildRequestFluent.RevisionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SourceRevisionBuilder builder;
    
            RevisionNestedImpl(SourceRevision item){
                    this.builder = new SourceRevisionBuilder(this, item);
            }
            RevisionNestedImpl(){
                    this.builder = new SourceRevisionBuilder(this);
            }
    
    public N and(){
            return (N) BuildRequestFluentImpl.this.withRevision(builder.build());
    }
    public N endRevision(){
            return and();
    }

}
    public class TriggeredByNestedImpl<N> extends BuildTriggerCauseFluentImpl<BuildRequestFluent.TriggeredByNested<N>> implements BuildRequestFluent.TriggeredByNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildTriggerCauseBuilder builder;
    
            TriggeredByNestedImpl(BuildTriggerCause item){
                    this.builder = new BuildTriggerCauseBuilder(this, item);
            }
            TriggeredByNestedImpl(){
                    this.builder = new BuildTriggerCauseBuilder(this);
            }
    
    public N and(){
            return (N) BuildRequestFluentImpl.this.addToTriggeredBy(builder.build());
    }
    public N endTriggeredBy(){
            return and();
    }

}
    public class TriggeredByImageNestedImpl<N> extends ObjectReferenceFluentImpl<BuildRequestFluent.TriggeredByImageNested<N>> implements BuildRequestFluent.TriggeredByImageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            TriggeredByImageNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            TriggeredByImageNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) BuildRequestFluentImpl.this.withTriggeredByImage(builder.build());
    }
    public N endTriggeredByImage(){
            return and();
    }

}


}
