package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ThirdPartyResourceListBuilder extends ThirdPartyResourceListFluentImpl<ThirdPartyResourceListBuilder> implements VisitableBuilder<ThirdPartyResourceList,ThirdPartyResourceListBuilder>{

    ThirdPartyResourceListFluent<?> fluent;
    Boolean validationEnabled;

    public ThirdPartyResourceListBuilder(){
            this(true);
    }
    public ThirdPartyResourceListBuilder(Boolean validationEnabled){
            this(new ThirdPartyResourceList(), validationEnabled);
    }
    public ThirdPartyResourceListBuilder(ThirdPartyResourceListFluent<?> fluent){
            this(fluent, true);
    }
    public ThirdPartyResourceListBuilder(ThirdPartyResourceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ThirdPartyResourceList(), validationEnabled);
    }
    public ThirdPartyResourceListBuilder(ThirdPartyResourceListFluent<?> fluent,ThirdPartyResourceList instance){
            this(fluent, instance, true);
    }
    public ThirdPartyResourceListBuilder(ThirdPartyResourceListFluent<?> fluent,ThirdPartyResourceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ThirdPartyResourceListBuilder(ThirdPartyResourceList instance){
            this(instance,true);
    }
    public ThirdPartyResourceListBuilder(ThirdPartyResourceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ThirdPartyResourceList build(){
            ThirdPartyResourceList buildable = new ThirdPartyResourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ThirdPartyResourceListBuilder that = (ThirdPartyResourceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
