package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class LabelSelectorBuilder extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.LabelSelector,io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder>{

    io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public LabelSelectorBuilder(){
            this(true);
    }
    public LabelSelectorBuilder(Boolean validationEnabled){
            this(new LabelSelector(), validationEnabled);
    }
    public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LabelSelector(), validationEnabled);
    }
    public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.LabelSelector instance){
            this(fluent, instance, true);
    }
    public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.LabelSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMatchExpressions(instance.getMatchExpressions()); 
            fluent.withMatchLabels(instance.getMatchLabels()); 
            this.validationEnabled = validationEnabled; 
    }
    public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelector instance){
            this(instance,true);
    }
    public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.extensions.LabelSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMatchExpressions(instance.getMatchExpressions()); 
            this.withMatchLabels(instance.getMatchLabels()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.LabelSelector build(){
            LabelSelector buildable = new LabelSelector(fluent.getMatchExpressions(),fluent.getMatchLabels());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LabelSelectorBuilder that = (LabelSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
