package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class DaemonSetListBuilder extends DaemonSetListFluentImpl<DaemonSetListBuilder> implements VisitableBuilder<DaemonSetList,DaemonSetListBuilder>{

    DaemonSetListFluent<?> fluent;
    Boolean validationEnabled;

    public DaemonSetListBuilder(){
            this(true);
    }
    public DaemonSetListBuilder(Boolean validationEnabled){
            this(new DaemonSetList(), validationEnabled);
    }
    public DaemonSetListBuilder(DaemonSetListFluent<?> fluent){
            this(fluent, true);
    }
    public DaemonSetListBuilder(DaemonSetListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DaemonSetList(), validationEnabled);
    }
    public DaemonSetListBuilder(DaemonSetListFluent<?> fluent,DaemonSetList instance){
            this(fluent, instance, true);
    }
    public DaemonSetListBuilder(DaemonSetListFluent<?> fluent,DaemonSetList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public DaemonSetListBuilder(DaemonSetList instance){
            this(instance,true);
    }
    public DaemonSetListBuilder(DaemonSetList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public DaemonSetList build(){
            DaemonSetList buildable = new DaemonSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetListBuilder that = (DaemonSetListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
