package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ServiceAccountListFluent<A extends ServiceAccountListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ServiceAccount... items);
    public A removeFromItems(ServiceAccount... items);
    public List<ServiceAccount> getItems();
    public A withItems(List<ServiceAccount> items);
    public A withItems(ServiceAccount... items);
    public ServiceAccountListFluent.ItemsNested<A> addNewItem();
    public ServiceAccountListFluent.ItemsNested<A> addNewItemLike(ServiceAccount item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ServiceAccountListFluent.MetadataNested<A> withNewMetadata();
    public ServiceAccountListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ServiceAccountListFluent.MetadataNested<A> editMetadata();
    public ServiceAccountListFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceAccountListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceAccountFluent<ServiceAccountListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ServiceAccountListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
