package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ServiceAccountFluent<A extends ServiceAccountFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToImagePullSecrets(LocalObjectReference... items);
    public A removeFromImagePullSecrets(LocalObjectReference... items);
    public List<LocalObjectReference> getImagePullSecrets();
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets);
    public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
    public A addNewImagePullSecret(String name);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ServiceAccountFluent.MetadataNested<A> withNewMetadata();
    public ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceAccountFluent.MetadataNested<A> editMetadata();
    public ServiceAccountFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceAccountFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToSecrets(ObjectReference... items);
    public A removeFromSecrets(ObjectReference... items);
    public List<ObjectReference> getSecrets();
    public A withSecrets(List<ObjectReference> secrets);
    public A withSecrets(ObjectReference... secrets);
    public ServiceAccountFluent.SecretsNested<A> addNewSecret();
    public ServiceAccountFluent.SecretsNested<A> addNewSecretLike(ObjectReference item);

    public interface ImagePullSecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<ServiceAccountFluent.ImagePullSecretsNested<N>>{

        
    public N and();    public N endImagePullSecret();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ServiceAccountFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<ServiceAccountFluent.SecretsNested<N>>{

        
    public N and();    public N endSecret();
}


}
