package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ResourceFieldSelectorBuilder extends ResourceFieldSelectorFluentImpl<ResourceFieldSelectorBuilder> implements VisitableBuilder<ResourceFieldSelector,ResourceFieldSelectorBuilder>{

    ResourceFieldSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceFieldSelectorBuilder(){
            this(true);
    }
    public ResourceFieldSelectorBuilder(Boolean validationEnabled){
            this(new ResourceFieldSelector(), validationEnabled);
    }
    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ResourceFieldSelector(), validationEnabled);
    }
    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,ResourceFieldSelector instance){
            this(fluent, instance, true);
    }
    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,ResourceFieldSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainerName(instance.getContainerName()); 
            fluent.withDivisor(instance.getDivisor()); 
            fluent.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance){
            this(instance,true);
    }
    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainerName(instance.getContainerName()); 
            this.withDivisor(instance.getDivisor()); 
            this.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }

    public ResourceFieldSelector build(){
            ResourceFieldSelector buildable = new ResourceFieldSelector(fluent.getContainerName(),fluent.getDivisor(),fluent.getResource());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceFieldSelectorBuilder that = (ResourceFieldSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
