package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class PodSecurityContextBuilder extends PodSecurityContextFluentImpl<PodSecurityContextBuilder> implements VisitableBuilder<PodSecurityContext,PodSecurityContextBuilder>{

    PodSecurityContextFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityContextBuilder(){
            this(true);
    }
    public PodSecurityContextBuilder(Boolean validationEnabled){
            this(new PodSecurityContext(), validationEnabled);
    }
    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent){
            this(fluent, true);
    }
    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PodSecurityContext(), validationEnabled);
    }
    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,PodSecurityContext instance){
            this(fluent, instance, true);
    }
    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,PodSecurityContext instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFsGroup(instance.getFsGroup()); 
            fluent.withRunAsNonRoot(instance.getRunAsNonRoot()); 
            fluent.withRunAsUser(instance.getRunAsUser()); 
            fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); 
            fluent.withSupplementalGroups(instance.getSupplementalGroups()); 
            this.validationEnabled = validationEnabled; 
    }
    public PodSecurityContextBuilder(PodSecurityContext instance){
            this(instance,true);
    }
    public PodSecurityContextBuilder(PodSecurityContext instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFsGroup(instance.getFsGroup()); 
            this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
            this.withRunAsUser(instance.getRunAsUser()); 
            this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
            this.withSupplementalGroups(instance.getSupplementalGroups()); 
            this.validationEnabled = validationEnabled; 
    }

    public PodSecurityContext build(){
            PodSecurityContext buildable = new PodSecurityContext(fluent.getFsGroup(),fluent.isRunAsNonRoot(),fluent.getRunAsUser(),fluent.getSeLinuxOptions(),fluent.getSupplementalGroups());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodSecurityContextBuilder that = (PodSecurityContextBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
